/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen;

import com.daderpduck.seamless_loading_screen.config.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="seamless_loading_screen")
public class SeamlessLoadingScreen {
    public static final String MOD_ID = "seamless_loading_screen";
    public static final Logger LOGGER = LogManager.getLogger();

    public SeamlessLoadingScreen() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        Config.init(FMLPaths.CONFIGDIR.get().resolve("seamless_loading_screen-client.toml").toString());
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> null, (version, network) -> network));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        try {
            String gameDirPath = Minecraft.m_91087_().f_91069_.getPath();
            Files.createDirectories(Paths.get(gameDirPath, "screenshots/worlds/singleplayer"), new FileAttribute[0]);
            Files.createDirectories(Paths.get(gameDirPath, "screenshots/worlds/servers"), new FileAttribute[0]);
            Files.createDirectories(Paths.get(gameDirPath, "screenshots/worlds/realms"), new FileAttribute[0]);
            Files.createDirectories(Paths.get(gameDirPath, "screenshots/worlds/archive"), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create screenshot directories", (Throwable)e);
        }
    }
}

