/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen.config;

import com.daderpduck.seamless_loading_screen.SeamlessLoadingScreen;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue HoldTime;
    public static final ForgeConfigSpec.IntValue FadeTime;
    public static final ForgeConfigSpec.BooleanValue DisableCamera;
    public static final ForgeConfigSpec.EnumValue<ScreenshotResolution> Resolution;
    public static final ForgeConfigSpec.BooleanValue UpdateWorldIcon;
    public static final ForgeConfigSpec.BooleanValue ArchiveScreenshots;

    public static void init(String pathName) {
        SeamlessLoadingScreen.LOGGER.debug("Loading config: {}", (Object)pathName);
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(pathName)).sync().autoreload().writingMode(WritingMode.REPLACE).build();
        config.load();
        config.save();
        SPEC.setConfig((CommentedConfig)config);
        SeamlessLoadingScreen.LOGGER.debug("Loaded config: {}", (Object)pathName);
    }

    public static void save() {
        SPEC.save();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        HoldTime = builder.comment("Delay before fade for chunks to load").translation("seamless_loading_screen.config.hold_time.desc").defineInRange("HoldTime", 80, 0, Integer.MAX_VALUE);
        FadeTime = builder.comment("Fade duration").translation("seamless_loading_screen.config.fade_time.desc").defineInRange("FadeTime", 20, 0, Integer.MAX_VALUE);
        DisableCamera = builder.comment("Disables camera movement until fade is complete").translation("seamless_loading_screen.config.disable_camera.desc").define("DisableCamera", true);
        Resolution = builder.comment("Screenshot resolution").translation("seamless_loading_screen.config.resolution.desc").defineEnum("Resolution", (Enum)ScreenshotResolution.NORMAL);
        UpdateWorldIcon = builder.comment("Updates the world icon periodically").translation("seamless_loading_screen.config.update_world_icon.desc").define("UpdateWorldIcon", true);
        ArchiveScreenshots = builder.comment("Archives previous screenshots to the archive folder").translation("seamless_loading_screen.config.archive_screenshots.desc").define("ArchiveScreenshots", false);
        SPEC = builder.build();
    }

    public static enum ScreenshotResolution {
        NATIVE(0, 0),
        NORMAL(4000, 1600),
        R4K(4000, 2160),
        R8K(7900, 4320);

        public int width;
        public int height;

        private ScreenshotResolution(int widthIn, int heightIn) {
            this.width = widthIn;
            this.height = heightIn;
        }
    }
}

