/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen.events;

import com.daderpduck.seamless_loading_screen.ScreenshotLoader;
import com.daderpduck.seamless_loading_screen.ScreenshotRenderer;
import com.daderpduck.seamless_loading_screen.ScreenshotTaker;
import com.daderpduck.seamless_loading_screen.SeamlessLoadingScreen;
import com.daderpduck.seamless_loading_screen.config.Config;
import com.daderpduck.seamless_loading_screen.events.DeleteSaveEvent;
import com.daderpduck.seamless_loading_screen.events.PreLoadWorldEvent;
import com.daderpduck.seamless_loading_screen.events.PreUnloadWorldEvent;
import com.daderpduck.seamless_loading_screen.events.RealmsJoinEvent;
import com.daderpduck.seamless_loading_screen.events.UpdatePlayerLookEvent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="seamless_loading_screen")
public class EventHandler {
    private static boolean takenScreenshot = false;

    @SubscribeEvent
    public static void initGuiEvent(ScreenEvent.InitScreenEvent event) {
        Screen screen = event.getScreen();
        Minecraft mc = Minecraft.m_91087_();
        if (screen instanceof ConnectScreen) {
            ServerData serverData = mc.m_91089_();
            if (serverData == null) {
                return;
            }
            Minecraft.m_91087_().f_91067_.m_91599_();
            ServerAddress serveraddress = ServerAddress.m_171864_((String)serverData.f_105363_);
            ScreenshotLoader.setScreenshotServer(serveraddress.m_171863_(), serveraddress.m_171866_());
        } else if (screen instanceof DisconnectedScreen) {
            ScreenshotLoader.resetState();
        } else if (screen instanceof RealmsGenericErrorScreen) {
            ScreenshotLoader.resetState();
        }
    }

    @SubscribeEvent
    public static void onWorldJoin(PreLoadWorldEvent event) {
        Minecraft.m_91087_().f_91067_.m_91599_();
        ScreenshotLoader.setScreenshotWorld(event.worldName);
        ScreenshotTaker.shouldSaveScreenshot(true);
    }

    @SubscribeEvent
    public static void onRealmsJoin(RealmsJoinEvent event) {
        Minecraft.m_91087_().f_91067_.m_91599_();
        ScreenshotLoader.setScreenshotRealm(event.realmsServer.m_87512_());
        ScreenshotTaker.shouldSaveScreenshot(true);
    }

    @SubscribeEvent
    public static void onUnloadWorld(PreUnloadWorldEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!takenScreenshot && mc.f_91073_ != null) {
            ScreenshotTaker.takeScreenshot(ignored -> {
                takenScreenshot = true;
                mc.m_91320_(event.nextScreen);
            });
            ScreenshotLoader.resetState();
            event.setCanceled(true);
        } else {
            takenScreenshot = false;
        }
    }

    @SubscribeEvent
    public static void onMouseMove(UpdatePlayerLookEvent event) {
        if (ScreenshotRenderer.Fader.isFading() && ((Boolean)Config.DisableCamera.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderBackground(ScreenEvent.BackgroundDrawnEvent event) {
        if (ScreenshotLoader.isLoaded()) {
            ScreenshotRenderer.renderScreenshot(event.getScreen().f_96544_, event.getScreen().f_96543_, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onSaveDelete(DeleteSaveEvent event) {
        ScreenshotLoader.setScreenshotWorld(event.saveDir.getFileName().toString());
        Path screenshotPath = ScreenshotLoader.getCurrentScreenshotPath();
        try {
            SeamlessLoadingScreen.LOGGER.info("Deleting screenshot at {}", (Object)screenshotPath);
            Files.deleteIfExists(screenshotPath);
        }
        catch (IOException e) {
            SeamlessLoadingScreen.LOGGER.error("Failed to delete screenshot", (Throwable)e);
        }
        ScreenshotLoader.resetState();
    }

    @SubscribeEvent
    public static void onRenderTickEnd(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (ScreenshotLoader.isLoaded() && mc.f_91080_ == null) {
            float alpha = ScreenshotRenderer.Fader.getAlpha();
            if (alpha > 0.0f) {
                int scaledHeight = mc.m_91268_().m_85446_();
                int scaledWidth = mc.m_91268_().m_85445_();
                ScreenshotRenderer.renderScreenshot(scaledHeight, scaledWidth, alpha);
                if (ScreenshotRenderer.Fader.isHolding() && mc.f_91080_ == null) {
                    GuiComponent.m_93215_((PoseStack)new PoseStack(), (Font)mc.f_91062_, (Component)new TranslatableComponent("multiplayer.downloadingTerrain"), (int)(scaledWidth / 2), (int)70, (int)0xFFFFFF);
                }
                ScreenshotRenderer.Fader.tick(event.renderTickTime);
            } else {
                ScreenshotRenderer.Fader.reset();
                ScreenshotLoader.resetState();
            }
        }
    }
}

