/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.entity.CurtainBlockEntity;
import com.starfish_studios.another_furniture.block.properties.CurtainType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<CurtainType> TYPE = ModBlockStateProperties.CURTAIN_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private final DyeColor color;

    public CurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)CurtainType.LEFT))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? Shapes.m_83040_() : super.m_5939_(state, level, pos, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        CurtainType type;
        Direction direction = context.m_8125_().m_122424_();
        if (direction.m_122434_() == Direction.Axis.X) {
            type = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_() > 0.5 ? CurtainType.RIGHT : CurtainType.LEFT;
        } else {
            CurtainType curtainType = type = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_() > 0.5 ? CurtainType.RIGHT : CurtainType.LEFT;
        }
        if (context.m_8125_() == Direction.NORTH || context.m_8125_() == Direction.EAST) {
            type = type == CurtainType.LEFT ? CurtainType.RIGHT : CurtainType.LEFT;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)((Object)type));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        boolean rr_side;
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        CurtainType type = (CurtainType)((Object)state.m_61143_(TYPE));
        BlockState l_state = level.m_8055_(pos.m_142300_(facing.m_122427_()));
        BlockState r_state = level.m_8055_(pos.m_142300_(facing.m_122428_()));
        boolean l_side = l_state.m_60734_() instanceof CurtainBlock && l_state.m_61143_((Property)FACING) == facing;
        boolean r_side = r_state.m_60734_() instanceof CurtainBlock && r_state.m_61143_((Property)FACING) == facing;
        BlockState ll_state = level.m_8055_(pos.m_5484_(facing.m_122427_(), 2));
        BlockState rr_state = level.m_8055_(pos.m_5484_(facing.m_122428_(), 2));
        boolean ll_side = ll_state.m_60734_() instanceof CurtainBlock && ll_state.m_61143_((Property)FACING) == facing;
        boolean bl = rr_side = rr_state.m_60734_() instanceof CurtainBlock && rr_state.m_61143_((Property)FACING) == facing;
        if (type == CurtainType.RIGHT && l_side && ll_side && l_state.m_61143_(TYPE) == CurtainType.RIGHT && ll_state.m_61143_(TYPE) == CurtainType.LEFT) {
            level.m_46597_(pos.m_142300_(facing.m_122427_()), (BlockState)l_state.m_61124_(TYPE, (Comparable)((Object)CurtainType.MIDDLE)));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)((Boolean)l_state.m_61143_((Property)OPEN))), 2);
        } else if (type == CurtainType.LEFT && r_side && rr_side && r_state.m_61143_(TYPE) == CurtainType.LEFT && rr_state.m_61143_(TYPE) == CurtainType.RIGHT) {
            level.m_46597_(pos.m_142300_(facing.m_122428_()), (BlockState)r_state.m_61124_(TYPE, (Comparable)((Object)CurtainType.MIDDLE)));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)((Boolean)r_state.m_61143_((Property)OPEN))), 2);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean rSide;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        CurtainType type = (CurtainType)((Object)state.m_61143_(TYPE));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState lState = level.m_8055_(currentPos.m_142300_(facing.m_122427_()));
        BlockState rState = level.m_8055_(currentPos.m_142300_(facing.m_122428_()));
        boolean lSide = lState.m_60734_() instanceof CurtainBlock && lState.m_61143_((Property)FACING) == facing;
        boolean bl = rSide = rState.m_60734_() instanceof CurtainBlock && rState.m_61143_((Property)FACING) == facing;
        if (!(type != CurtainType.MIDDLE || lSide && lState.m_61143_(TYPE) == CurtainType.LEFT && rSide && rState.m_61143_(TYPE) == CurtainType.RIGHT)) {
            state = lSide && lState.m_61143_(TYPE) == CurtainType.LEFT ? (BlockState)state.m_61124_(TYPE, (Comparable)((Object)CurtainType.RIGHT)) : (BlockState)state.m_61124_(TYPE, (Comparable)((Object)CurtainType.LEFT));
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        state = (BlockState)state.m_61122_((Property)OPEN);
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        boolean top = (Boolean)state.m_61143_((Property)TOP);
        CurtainType type = (CurtainType)((Object)state.m_61143_(TYPE));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos startpos = pos;
        int times = 1;
        if (type == CurtainType.MIDDLE) {
            times = 3;
            startpos = pos.m_142300_(facing.m_122427_());
        } else if (type == CurtainType.RIGHT) {
            BlockState left = level.m_8055_(startpos.m_142300_(facing.m_122427_()));
            if (left.m_60734_() instanceof CurtainBlock && left.m_61143_(TYPE) == CurtainType.MIDDLE && (Boolean)left.m_61143_((Property)TOP) == top && left.m_61143_((Property)FACING) == facing) {
                times = 3;
                startpos = pos.m_5484_(facing.m_122427_(), 2);
            } else if (left.m_60734_() instanceof CurtainBlock && left.m_61143_(TYPE) == CurtainType.LEFT && (Boolean)left.m_61143_((Property)TOP) == top && left.m_61143_((Property)FACING) == facing) {
                times = 2;
                startpos = pos.m_142300_(facing.m_122427_());
            }
        } else {
            BlockState right = level.m_8055_(startpos.m_142300_(facing.m_122428_()));
            if (right.m_60734_() instanceof CurtainBlock && right.m_61143_(TYPE) == CurtainType.MIDDLE && (Boolean)right.m_61143_((Property)TOP) == top && right.m_61143_((Property)FACING) == facing) {
                times = 3;
            } else if (right.m_60734_() instanceof CurtainBlock && right.m_61143_(TYPE) == CurtainType.RIGHT && (Boolean)right.m_61143_((Property)TOP) == top && right.m_61143_((Property)FACING) == facing) {
                times = 2;
            }
        }
        for (int i = 0; i < times; ++i) {
            BlockState newstate = level.m_8055_(startpos);
            if (newstate.m_60734_() instanceof CurtainBlock) {
                level.m_7731_(startpos, (BlockState)newstate.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 2);
            }
            startpos = startpos.m_142300_(facing.m_122428_());
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        level.m_5594_(null, pos, AFSoundEvents.CURTAIN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, OPEN, TOP, WATERLOGGED});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CurtainBlockEntity(pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public String getColor() {
        return this.color.toString();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

