/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.compiler;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.source.FileResolution;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;
import top.leonx.irisflw.IrisFlw;
import top.leonx.irisflw.accessors.NewWorldRenderingPipelineAccessor;
import top.leonx.irisflw.accessors.ProgramSourceAccessor;
import top.leonx.irisflw.accessors.WorldProgramAccessor;
import top.leonx.irisflw.flywheel.IrisFlwCompatShaderWarp;

public abstract class IrisProgramCompilerBase<P extends WorldProgram> {
    Map<WorldRenderingPipeline, HashMap<ProgramContext, P>> programCache = new HashMap<WorldRenderingPipeline, HashMap<ProgramContext, P>>();
    Map<WorldRenderingPipeline, HashMap<ProgramContext, P>> shadowProgramCache = new HashMap<WorldRenderingPipeline, HashMap<ProgramContext, P>>();
    protected final GlProgram.Factory<P> factory;
    private static int programCounter = 0;

    public IrisProgramCompilerBase(GlProgram.Factory<P> factory, Template<? extends VertexData> template, FileResolution header) {
        this.factory = factory;
    }

    public P getProgram(ProgramContext ctx, boolean isShadow) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
            HashMap cache = isShadow ? this.shadowProgramCache.computeIfAbsent(pipeline, key -> new HashMap()) : this.programCache.computeIfAbsent(pipeline, key -> new HashMap());
            if (!cache.containsKey(ctx)) {
                P created = this.createIrisShaderProgram(ctx, isShadow);
                cache.put(ctx, created);
                if (created == null && Minecraft.m_91087_().f_91074_ != null) {
                    if (isShadow) {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)new TextComponent(String.format("Fail to compile %s_%s_%s", "Shadow", ctx.spec.name.m_135827_(), ctx.spec.name.m_135815_())), false);
                    } else {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)new TextComponent(String.format("Fail to compile %s_%s_%s", "Gbuffers_flw", ctx.spec.name.m_135827_(), ctx.spec.name.m_135815_())), false);
                    }
                }
            }
            return (P)((WorldProgram)cache.get(ctx));
        }
        return null;
    }

    abstract P createIrisShaderProgram(ProgramContext var1, boolean var2);

    protected P createWorldProgramBySource(ProgramContext ctx, boolean isShadow, NewWorldRenderingPipelineAccessor pipeline, ProgramSource processedSource) {
        ShaderInstance override = null;
        try {
            String randomId = String.valueOf(programCounter);
            ++programCounter;
            override = isShadow ? pipeline.callCreateShadowShader(String.format("shadow_flw_%s_%s_%s", ctx.spec.name.m_135827_(), ctx.spec.name.m_135815_(), randomId), processedSource, AlphaTest.ALWAYS, DefaultVertexFormat.f_85817_, false) : pipeline.callCreateShader(String.format("gbuffers_flw_%s_%s_%s", ctx.spec.name.m_135827_(), ctx.spec.name.m_135815_(), randomId), processedSource, AlphaTest.ALWAYS, DefaultVertexFormat.f_85817_, FogMode.OFF, false);
        }
        catch (Exception exception) {
            IrisFlw.LOGGER.error("Fail to compile shader", (Throwable)exception);
        }
        if (override != null) {
            WorldProgram program = (WorldProgram)this.factory.create(ctx.spec.name, override.m_142658_());
            ((WorldProgramAccessor)program).setShader(new IrisFlwCompatShaderWarp(override));
            return (P)program;
        }
        return null;
    }

    @NotNull
    protected ProgramSource programSourceOverrideVertexSource(ProgramContext ctx, ProgramSet programSet, ProgramSource source, String vertexSource) {
        ShaderProperties properties = ((ProgramSourceAccessor)source).getShaderProperties();
        BlendModeOverride blendModeOverride = ((ProgramSourceAccessor)source).getBlendModeOverride();
        return new ProgramSource(source.getName() + "_" + ctx.spec.name.toString().replace(":", "_") + UUID.randomUUID(), vertexSource, (String)source.getGeometrySource().orElse(null), (String)source.getFragmentSource().orElse(null), programSet, properties, blendModeOverride);
    }

    public void clear() {
        this.programCache.clear();
        this.shadowProgramCache.clear();
    }
}

