/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.modernworldcreation.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.modernworldcreation.CreateWorldScreenUtils;
import de.keksuccino.modernworldcreation.ModernWorldCreation;
import de.keksuccino.modernworldcreation.ToggleModeButton;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreateWorldScreen.class})
public abstract class MixinCreateWorldScreen
extends Screen {
    private static final BaseComponent ENTER_SEED_TEXT = new TranslatableComponent("selectWorld.enterSeed");
    private static final BaseComponent DESC_ENTER_SEED = new TranslatableComponent("selectWorld.seedInfo");
    private static final BaseComponent ENTER_WORLD_TEXT = new TranslatableComponent("selectWorld.enterName");
    private static final BaseComponent DESC_ALLOW_CHEATS = new TranslatableComponent("selectWorld.allowCommands.info");
    private static final BaseComponent DESC_GAMEMODE_SURVIVAL_LINE1 = new TranslatableComponent("selectWorld.gameMode.survival.line1");
    private static final BaseComponent DESC_GAMEMODE_SURVIVAL_LINE2 = new TranslatableComponent("selectWorld.gameMode.survival.line2");
    private static final BaseComponent DESC_GAMEMODE_CREATIVE_LINE1 = new TranslatableComponent("selectWorld.gameMode.creative.line1");
    private static final BaseComponent DESC_GAMEMODE_CREATIVE_LINE2 = new TranslatableComponent("selectWorld.gameMode.creative.line2");
    private static final BaseComponent DESC_GAMEMODE_HARDCORE_LINE1 = new TranslatableComponent("selectWorld.gameMode.hardcore.line1");
    private static final BaseComponent DESC_GAMEMODE_HARDCORE_LINE2 = new TranslatableComponent("selectWorld.gameMode.hardcore.line2");
    private static final ResourceLocation BTN_TEXTURE_SURVIVAL = new ResourceLocation("modernworldcreation", "gamemodes/background_survival.png");
    private static final ResourceLocation BTN_TEXTURE_CREATIVE = new ResourceLocation("modernworldcreation", "gamemodes/background_creative.png");
    private static final ResourceLocation BTN_TEXTURE_HARDCORE = new ResourceLocation("modernworldcreation", "gamemodes/background_hardcore.png");
    private static final ResourceLocation BTN_TEXTURE_ARROW_LEFT_NORMAL = new ResourceLocation("modernworldcreation", "arrow_left_normal.png");
    private static final ResourceLocation BTN_TEXTURE_ARROW_RIGHT_NORMAL = new ResourceLocation("modernworldcreation", "arrow_right_normal.png");
    private static final ResourceLocation BTN_TEXTURE_ARROW_LEFT_HOVER = new ResourceLocation("modernworldcreation", "arrow_left_hover.png");
    private static final ResourceLocation BTN_TEXTURE_ARROW_RIGHT_HOVER = new ResourceLocation("modernworldcreation", "arrow_right_hover.png");
    @Shadow
    private EditBox f_100856_;
    @Shadow
    private boolean f_170146_;
    @Shadow
    private WorldGenSettingsComponent f_100847_;
    @Shadow
    private String f_100857_;
    @Shadow
    private boolean f_100830_;
    @Shadow
    public boolean f_100845_;
    @Shadow
    private boolean f_100829_;
    @Shadow
    private CycleButton f_100840_;
    @Shadow
    private CycleButton f_100835_;
    @Shadow
    private CycleButton f_100836_;
    @Shadow
    private Button f_100837_;
    @Shadow
    private Button f_100839_;
    @Shadow
    private Button f_100838_;
    @Shadow
    private Button f_100834_;
    private ToggleModeButton gamemodeSurvivalBtn;
    private ToggleModeButton gamemodeCreativeBtn;
    private ToggleModeButton gamemodeHardcoreBtn;
    private AdvancedButton gamemodeLeftBtn;
    private AdvancedButton gamemodeRightBtn;
    private AbstractWidget cancelButton = null;
    private AdvancedButton customCommandsButton = null;
    private AdvancedButton backButton;
    private Color headerFooterColor;

    protected MixinCreateWorldScreen(BaseComponent titleIn) {
        super((Component)titleIn);
    }

    @Inject(at={@At(value="TAIL")}, method={"init()V"}, cancellable=true)
    private void onInit(CallbackInfo info) {
        this.headerFooterColor = new Color(0, 0, 0, 190);
        this.cancelButton = null;
        for (Widget b : this.f_169369_) {
            if (!(b instanceof AbstractWidget) || !((AbstractWidget)b).m_6035_().getString().equals(CommonComponents.f_130656_.getString())) continue;
            this.cancelButton = (AbstractWidget)b;
            break;
        }
        this.m_169411_((GuiEventListener)this.f_100835_);
        this.m_169411_((GuiEventListener)this.f_100840_);
        this.f_100856_.f_93621_ = 40;
        int midX = this.f_96543_ / 2;
        int topY = this.f_100856_.f_93621_;
        this.gamemodeLeftBtn = (AdvancedButton)this.m_142416_((GuiEventListener)new AdvancedButton(midX - 145 - 40 - 10, topY + 38 + 22 - 20, 40, 40, "", press -> this.switchToNextGamemode(CreateWorldScreenUtils.Direction.LEFT)));
        this.gamemodeLeftBtn.setBackgroundTexture(BTN_TEXTURE_ARROW_LEFT_NORMAL, BTN_TEXTURE_ARROW_LEFT_HOVER);
        this.gamemodeRightBtn = (AdvancedButton)this.m_142416_((GuiEventListener)new AdvancedButton(midX + 55 + 90 + 10, topY + 38 + 22 - 20, 40, 40, "", press -> this.switchToNextGamemode(CreateWorldScreenUtils.Direction.RIGHT)));
        this.gamemodeRightBtn.setBackgroundTexture(BTN_TEXTURE_ARROW_RIGHT_NORMAL, BTN_TEXTURE_ARROW_RIGHT_HOVER);
        CreateWorldScreenUtils.Gamemode cachedSelectedGamemode = this.getVanillaGameMode();
        this.gamemodeSurvivalBtn = (ToggleModeButton)this.m_142416_((GuiEventListener)new ToggleModeButton(midX - 145, topY + 38, 90, 45, BTN_TEXTURE_SURVIVAL, "Survival", false, press -> this.setGamemode(CreateWorldScreenUtils.Gamemode.SURVIVAL)));
        this.gamemodeSurvivalBtn.setInfoText(DESC_GAMEMODE_SURVIVAL_LINE1.getString(), DESC_GAMEMODE_SURVIVAL_LINE2.getString());
        if (cachedSelectedGamemode == CreateWorldScreenUtils.Gamemode.SURVIVAL) {
            this.gamemodeSurvivalBtn.setSelected(true);
        }
        this.gamemodeCreativeBtn = (ToggleModeButton)this.m_142416_((GuiEventListener)new ToggleModeButton(midX - 45, topY + 38, 90, 45, BTN_TEXTURE_CREATIVE, "Creative", false, press -> this.setGamemode(CreateWorldScreenUtils.Gamemode.CREATIVE)));
        this.gamemodeCreativeBtn.setInfoText(DESC_GAMEMODE_CREATIVE_LINE1.getString(), DESC_GAMEMODE_CREATIVE_LINE2.getString());
        if (cachedSelectedGamemode == CreateWorldScreenUtils.Gamemode.CREATIVE) {
            this.gamemodeCreativeBtn.setSelected(true);
        }
        this.gamemodeHardcoreBtn = (ToggleModeButton)this.m_142416_((GuiEventListener)new ToggleModeButton(midX + 55, topY + 38, 90, 45, BTN_TEXTURE_HARDCORE, "Hardcore", false, press -> this.setGamemode(CreateWorldScreenUtils.Gamemode.HARDCORE)));
        this.gamemodeHardcoreBtn.setInfoText(DESC_GAMEMODE_HARDCORE_LINE1.getString(), DESC_GAMEMODE_HARDCORE_LINE2.getString());
        if (cachedSelectedGamemode == CreateWorldScreenUtils.Gamemode.HARDCORE) {
            this.gamemodeHardcoreBtn.setSelected(true);
        }
        if (!((Boolean)ModernWorldCreation.config.getOrDefault("show_gamemode_info", (Object)true)).booleanValue()) {
            this.gamemodeSurvivalBtn.showInfo = false;
            this.gamemodeCreativeBtn.showInfo = false;
            this.gamemodeHardcoreBtn.showInfo = false;
        }
        this.f_100839_.f_93620_ = midX + 5;
        this.f_100839_.f_93621_ = topY + 38 + 50 + 10;
        this.f_100836_.f_93620_ = midX - this.f_100839_.m_5711_() - 5;
        this.f_100836_.f_93621_ = topY + 38 + 50 + 10;
        int allowCheatsX = midX - this.f_100840_.m_5711_() - 5;
        int allowCheatsY = topY + 38 + 50 + 10 + 20 + 4;
        this.customCommandsButton = (AdvancedButton)this.m_142416_((GuiEventListener)new AdvancedButton(allowCheatsX, allowCheatsY, this.f_100840_.m_5711_(), this.f_100840_.m_93694_(), new TranslatableComponent("selectWorld.allowCommands").getString(), false, press -> {
            this.f_100830_ = true;
            this.f_100829_ = !this.f_100829_;
        }){

            public Component m_6035_() {
                return MixinCreateWorldScreen.optionStatus(super.m_6035_(), MixinCreateWorldScreen.this.f_100829_ && !MixinCreateWorldScreen.this.f_100845_);
            }

            protected MutableComponent m_5646_() {
                return super.m_5646_().m_130946_(". ").m_7220_((Component)new TranslatableComponent("selectWorld.allowCommands.info"));
            }
        });
        if (((Boolean)ModernWorldCreation.config.getOrDefault("show_allowcheats_tooltip", (Object)false)).booleanValue()) {
            this.customCommandsButton.setDescription(new String[]{DESC_ALLOW_CHEATS.getString()});
        }
        this.f_100838_.f_93620_ = midX + 5;
        this.f_100838_.f_93621_ = topY + 38 + 50 + 10 + 20 + 4;
        this.f_100837_.f_93620_ = midX - this.f_100837_.m_5711_() / 2;
        this.f_100837_.f_93621_ = topY + 38 + 50 + 10 + 20 + 4 + 20 + 4;
        this.backButton = (AdvancedButton)this.m_142416_((GuiEventListener)new AdvancedButton(this.f_96543_ / 2 + 5, this.f_96544_ - 28 + 3, 150, 20, CommonComponents.f_130660_.getString(), false, press -> this.m_170148_()));
        if (this.f_100834_.f_93621_ - this.f_100837_.f_93621_ >= 100) {
            this.gamemodeSurvivalBtn.f_93621_ += 10;
            this.gamemodeCreativeBtn.f_93621_ += 10;
            this.gamemodeHardcoreBtn.f_93621_ += 10;
            this.gamemodeLeftBtn.f_93621_ += 10;
            this.gamemodeRightBtn.f_93621_ += 10;
            this.f_100836_.f_93621_ += 20;
            this.f_100839_.f_93621_ += 20;
            this.customCommandsButton.f_93621_ += 20;
            this.f_100838_.f_93621_ += 20;
            this.f_100837_.f_93621_ += 50;
        }
        this.f_100834_.f_93621_ += 3;
        if (this.cancelButton != null) {
            this.cancelButton.f_93621_ += 3;
        }
        this.m_170204_();
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    private void onRender(PoseStack matrix, int mouseX, int mouseY, float partialTicks, CallbackInfo info) {
        info.cancel();
        this.m_7333_(matrix);
        if (this.f_170146_) {
            this.gamemodeSurvivalBtn.f_93624_ = false;
            this.gamemodeCreativeBtn.f_93624_ = false;
            this.gamemodeHardcoreBtn.f_93624_ = false;
            this.customCommandsButton.f_93624_ = false;
            this.cancelButton.f_93624_ = false;
            this.f_100837_.f_93624_ = false;
            this.backButton.f_93624_ = true;
            this.gamemodeLeftBtn.f_93624_ = false;
            this.gamemodeRightBtn.f_93624_ = false;
        } else {
            this.gamemodeSurvivalBtn.f_93624_ = true;
            this.gamemodeCreativeBtn.f_93624_ = true;
            this.gamemodeHardcoreBtn.f_93624_ = true;
            this.customCommandsButton.f_93624_ = true;
            this.cancelButton.f_93624_ = true;
            this.f_100837_.f_93624_ = true;
            this.backButton.f_93624_ = false;
            this.gamemodeLeftBtn.f_93624_ = true;
            this.gamemodeRightBtn.f_93624_ = true;
        }
        if (((Boolean)ModernWorldCreation.config.getOrDefault("show_header", (Object)true)).booleanValue()) {
            MixinCreateWorldScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)22, (int)this.headerFooterColor.getRGB());
        }
        if (((Boolean)ModernWorldCreation.config.getOrDefault("bold_menu_title", (Object)true)).booleanValue()) {
            String titleString = "\u00a7l" + this.f_96539_.getString();
            int titleWidth = this.f_96547_.m_92895_(titleString);
            this.f_96547_.m_92883_(matrix, titleString, (float)(this.f_96543_ / 2 - titleWidth / 2), 7.0f, -1);
        } else {
            MixinCreateWorldScreen.m_93215_((PoseStack)matrix, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)7, (int)-1);
        }
        if (this.f_170146_) {
            MixinCreateWorldScreen.m_93243_((PoseStack)matrix, (Font)this.f_96547_, (Component)ENTER_SEED_TEXT, (int)(this.f_96543_ / 2 - 100), (int)47, (int)-6250336);
            MixinCreateWorldScreen.m_93243_((PoseStack)matrix, (Font)this.f_96547_, (Component)DESC_ENTER_SEED, (int)(this.f_96543_ / 2 - 100), (int)85, (int)-6250336);
            this.f_100847_.m_6305_(matrix, mouseX, mouseY, partialTicks);
        } else {
            MixinCreateWorldScreen.m_93243_((PoseStack)matrix, (Font)this.f_96547_, (Component)ENTER_WORLD_TEXT, (int)(this.f_96543_ / 2 - 100), (int)(this.f_100856_.f_93621_ - 12), (int)-6250336);
            this.f_100856_.m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
        if (((Boolean)ModernWorldCreation.config.getOrDefault("show_footer", (Object)true)).booleanValue()) {
            MixinCreateWorldScreen.m_93172_((PoseStack)matrix, (int)0, (int)(this.f_100834_.f_93621_ - 5), (int)this.f_96543_, (int)this.f_96544_, (int)this.headerFooterColor.getRGB());
        }
        for (int i = 0; i < this.f_169369_.size(); ++i) {
            ((Widget)this.f_169369_.get(i)).m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setWorldGenSettingsVisible"})
    private void onSetWorldGenSettingsVisible(boolean b, CallbackInfo info) {
        if (this.f_100847_.m_101403_()) {
            if (this.customCommandsButton != null) {
                this.customCommandsButton.f_93624_ = false;
            }
        } else if (this.customCommandsButton != null) {
            this.customCommandsButton.f_93624_ = !b;
        }
    }

    private void switchToNextGamemode(CreateWorldScreenUtils.Direction direction) {
        if (direction == CreateWorldScreenUtils.Direction.LEFT) {
            if (this.getSelectedGamemode() == CreateWorldScreenUtils.Gamemode.SURVIVAL) {
                this.setGamemode(CreateWorldScreenUtils.Gamemode.HARDCORE);
            } else if (this.getSelectedGamemode() == CreateWorldScreenUtils.Gamemode.CREATIVE) {
                this.setGamemode(CreateWorldScreenUtils.Gamemode.SURVIVAL);
            } else if (this.getSelectedGamemode() == CreateWorldScreenUtils.Gamemode.HARDCORE) {
                this.setGamemode(CreateWorldScreenUtils.Gamemode.CREATIVE);
            }
        }
        if (direction == CreateWorldScreenUtils.Direction.RIGHT) {
            if (this.getSelectedGamemode() == CreateWorldScreenUtils.Gamemode.SURVIVAL) {
                this.setGamemode(CreateWorldScreenUtils.Gamemode.CREATIVE);
            } else if (this.getSelectedGamemode() == CreateWorldScreenUtils.Gamemode.CREATIVE) {
                this.setGamemode(CreateWorldScreenUtils.Gamemode.HARDCORE);
            } else if (this.getSelectedGamemode() == CreateWorldScreenUtils.Gamemode.HARDCORE) {
                this.setGamemode(CreateWorldScreenUtils.Gamemode.SURVIVAL);
            }
        }
    }

    private void setGamemode(CreateWorldScreenUtils.Gamemode gamemode) {
        if (gamemode == CreateWorldScreenUtils.Gamemode.CREATIVE) {
            this.gamemodeCreativeBtn.setSelected(true);
            this.gamemodeSurvivalBtn.setSelected(false);
            this.gamemodeHardcoreBtn.setSelected(false);
        } else if (gamemode == CreateWorldScreenUtils.Gamemode.HARDCORE) {
            this.gamemodeHardcoreBtn.setSelected(true);
            this.gamemodeSurvivalBtn.setSelected(false);
            this.gamemodeCreativeBtn.setSelected(false);
        } else {
            this.gamemodeSurvivalBtn.setSelected(true);
            this.gamemodeCreativeBtn.setSelected(false);
            this.gamemodeHardcoreBtn.setSelected(false);
        }
        this.setVanillaGameMode(gamemode);
    }

    private CreateWorldScreenUtils.Gamemode getSelectedGamemode() {
        if (this.gamemodeCreativeBtn.isSelected()) {
            return CreateWorldScreenUtils.Gamemode.CREATIVE;
        }
        if (this.gamemodeHardcoreBtn.isSelected()) {
            return CreateWorldScreenUtils.Gamemode.HARDCORE;
        }
        return CreateWorldScreenUtils.Gamemode.SURVIVAL;
    }

    private void setVanillaGameMode(CreateWorldScreenUtils.Gamemode gm) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(CreateWorldScreen.class, (String)"m_100900_", (Class[])new Class[]{CreateWorldScreenUtils.getVanillaGameModeEnumClass()});
            m.invoke((Object)this, CreateWorldScreenUtils.getVanillaGameModeEnumElement(gm));
        }
        catch (Exception e) {
            ModernWorldCreation.LOGGER.error("ERROR IN: MixinCreateWorldScreen#setVanillaGameMode");
            ModernWorldCreation.printStackTrace(e);
        }
    }

    private CreateWorldScreenUtils.Gamemode getVanillaGameMode() {
        try {
            Field f = ObfuscationReflectionHelper.findField(CreateWorldScreen.class, (String)"f_100858_");
            Object mode = f.get((Object)this);
            if (mode != null) {
                Field f2 = CreateWorldScreenUtils.getVanillaGameModeEnumClass().getDeclaredField("f_101028_");
                f2.setAccessible(true);
                String modeString = (String)f2.get(mode);
                if (modeString != null) {
                    if (modeString.equals("survival")) {
                        return CreateWorldScreenUtils.Gamemode.SURVIVAL;
                    }
                    if (modeString.equals("hardcore")) {
                        return CreateWorldScreenUtils.Gamemode.HARDCORE;
                    }
                    if (modeString.equals("creative")) {
                        return CreateWorldScreenUtils.Gamemode.CREATIVE;
                    }
                    return CreateWorldScreenUtils.Gamemode.SURVIVAL;
                }
            }
        }
        catch (Exception e) {
            ModernWorldCreation.LOGGER.error("ERROR IN: MixinCreateWorldScreen#getVanillaGameMode");
            ModernWorldCreation.printStackTrace(e);
        }
        return null;
    }

    @Shadow
    protected abstract void m_170148_();

    @Shadow
    public abstract void m_170204_();

    private static MutableComponent optionStatus(Component c, boolean b) {
        return new TranslatableComponent(b ? "options.on.composed" : "options.off.composed", new Object[]{c});
    }
}

