/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.registry;

import com.google.common.collect.ImmutableMap;
import dev.momostudios.coldsweat.ColdSweat;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import java.util.HashMap;
import java.util.Map;

public class TempModifierRegistry {
    static Map<String, TempModifier> TEMP_MODIFIERS = new HashMap<String, TempModifier>();

    public static ImmutableMap<String, TempModifier> getEntries() {
        return ImmutableMap.copyOf(TEMP_MODIFIERS);
    }

    public static void register(TempModifier modifier) {
        if (TEMP_MODIFIERS.containsKey(modifier.getID())) {
            ColdSweat.LOGGER.error("Found duplicate TempModifier entries:\n{} ({})\n{} ({})", (Object)modifier.getClass().getName(), (Object)modifier.getID(), (Object)TEMP_MODIFIERS.get(modifier.getID()).getClass().getName(), (Object)modifier.getID());
            throw new RuntimeException("A TempModifier with the ID \"" + modifier.getID() + "\" already exists!");
        }
        TEMP_MODIFIERS.put(modifier.getID(), modifier);
    }

    public static void flush() {
        TEMP_MODIFIERS.clear();
    }

    public static TempModifier getEntryFor(String id) {
        try {
            return (TempModifier)TEMP_MODIFIERS.get(id).getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("TempModifier \"" + id + "\" does not have a default constructor. This will cause issues!");
            return TEMP_MODIFIERS.get(id);
        }
    }
}

