/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature;

import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;

public class Temperature {
    double temp;

    public Temperature(double tempIn) {
        this.temp = tempIn;
    }

    public Temperature() {
        this(0.0);
    }

    public void set(double amount) {
        this.temp = amount;
    }

    public void set(Temperature temperature) {
        this.temp = temperature.temp;
    }

    public Temperature add(double amount) {
        return new Temperature(this.temp + amount);
    }

    public Temperature add(Temperature amount) {
        return this.add(amount.temp);
    }

    public Temperature multiply(double amount) {
        return new Temperature(this.temp * amount);
    }

    public Temperature multiply(Temperature amount) {
        return this.multiply(amount.temp);
    }

    public Temperature divide(double amount) {
        return new Temperature(this.temp / amount);
    }

    public Temperature divide(Temperature amount) {
        return this.divide(amount.temp);
    }

    public double get() {
        return this.temp;
    }

    public Temperature with(@Nonnull Player player, TempModifier ... modifiers) {
        Temperature temp2 = new Temperature(this.temp);
        for (TempModifier modifier : modifiers) {
            if (modifier == null) continue;
            temp2.set(player.f_19797_ % modifier.getTickRate() == 0 || modifier.getTicksExisted() == 0 ? modifier.update(temp2, player) : modifier.getResult(temp2));
        }
        return temp2;
    }

    public Temperature with(@Nonnull Player player, @Nonnull Collection<TempModifier> modifiers) {
        return this.with(player, modifiers.toArray(new TempModifier[0]));
    }

    public Temperature copy() {
        return new Temperature(this.temp);
    }

    public String toString() {
        return "" + this.temp;
    }

    public static enum Units {
        F,
        C,
        MC;

    }

    public static enum Type {
        WORLD,
        MAX,
        MIN,
        CORE,
        BASE,
        BODY,
        RATE;

    }
}

