/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier;

import dev.momostudios.coldsweat.api.registry.BlockTempRegistry;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.block_temp.BlockTemp;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.world.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;

public class BlockTempModifier
extends TempModifier {
    @Override
    public Function<Temperature, Temperature> calculate(Player player) {
        HashMap<BlockTemp, Double> effectAmounts = new HashMap<BlockTemp, Double>();
        Level level = player.f_19853_;
        for (int x = -7; x < 7; ++x) {
            for (int z = -7; z < 7; ++z) {
                LevelChunk chunk = level.m_7726_().m_7131_(player.m_142538_().m_123341_() + x >> 4, player.m_142538_().m_123343_() + z >> 4);
                if (chunk == null) continue;
                for (int y = -7; y < 7; ++y) {
                    try {
                        double effectAmount;
                        BlockTemp be;
                        BlockPos blockpos = player.m_142538_().m_142082_(x, y, z);
                        LevelChunkSection subchunk = WorldHelper.getChunkSection((ChunkAccess)chunk, blockpos.m_123342_());
                        BlockState state = subchunk.m_62982_(blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF);
                        if (state.m_60795_() || (be = BlockTempRegistry.getEntryFor(state)) == null || be.equals(BlockTempRegistry.DEFAULT_BLOCK_EFFECT) || !CSMath.isBetween(effectAmount = effectAmounts.getOrDefault(be, 0.0).doubleValue(), be.minEffect(), be.maxEffect())) continue;
                        Vec3 pos = new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5);
                        AtomicInteger blocks = new AtomicInteger();
                        double playerRadius = player.m_20205_() / 2.0f;
                        Vec3 playerClosest = new Vec3(CSMath.clamp(pos.f_82479_, player.m_20185_() - playerRadius, player.m_20185_() + playerRadius), CSMath.clamp(pos.f_82480_, player.m_20186_(), player.m_20186_() + (double)player.m_20206_()), CSMath.clamp(pos.f_82481_, player.m_20189_() - playerRadius, player.m_20189_() + playerRadius));
                        double distance = CSMath.getDistance(playerClosest, pos);
                        double tempToAdd = be.getTemperature(player, state, blockpos, distance);
                        Vec3 ray = pos.m_82546_(playerClosest);
                        Direction direction = Direction.m_122366_((double)ray.f_82479_, (double)ray.f_82480_, (double)ray.f_82481_);
                        WorldHelper.forBlocksInRay(playerClosest, pos, level, (rayState, bpos) -> {
                            if (!bpos.equals((Object)blockpos) && WorldHelper.isSpreadBlocked(level, rayState, bpos, direction, direction)) {
                                blocks.getAndIncrement();
                            }
                        }, 3);
                        double blockDampening = blocks.get();
                        double blockTempTotal = effectAmount + tempToAdd / (blockDampening + 1.0);
                        effectAmounts.put(be, CSMath.clamp(blockTempTotal, be.minEffect(), be.maxEffect()));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return temp -> {
            for (Map.Entry effect : effectAmounts.entrySet()) {
                BlockTemp be = (BlockTemp)effect.getKey();
                double min = be.minTemperature();
                double max = be.maxTemperature();
                if (!CSMath.isInRange(temp.get(), min, max)) continue;
                temp.set(CSMath.clamp(temp.get() + (Double)effect.getValue(), min, max));
            }
            return temp;
        };
    }

    @Override
    public String getID() {
        return "cold_sweat:nearby_blocks";
    }
}

