/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;

public class SoulLampTempModifier
extends TempModifier {
    @Override
    public Function<Temperature, Temperature> calculate(Player player) {
        double almostMax = ConfigSettings.getInstance().maxTemp * 0.99;
        return temp -> {
            if (temp.get() < almostMax) {
                return temp;
            }
            return temp.multiply(Math.max(0.4, almostMax / temp.get()));
        };
    }

    @Override
    public String getID() {
        return "cold_sweat:soulspring_lamp";
    }
}

