/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;

public class WaterTempModifier
extends TempModifier {
    public WaterTempModifier() {
        this.addArgument("strength", 0.01);
    }

    public WaterTempModifier(double strength) {
        this.addArgument("strength", strength);
    }

    @Override
    public Function<Temperature, Temperature> calculate(Player player) {
        double worldTemp = TempHelper.getTemperature(player, Temperature.Type.WORLD).get();
        double maxTemp = ConfigSettings.getInstance().maxTemp;
        double minTemp = ConfigSettings.getInstance().minTemp;
        double strength = (Double)this.getArgument("strength");
        double returnRate = Math.min(-0.001, -0.001 - worldTemp / 800.0);
        double addAmount = player.m_20072_() ? 0.01 : (player.f_19853_.m_46758_(player.m_142538_()) ? 0.005 : returnRate);
        double maxStrength = CSMath.clamp(Math.abs(CSMath.average(maxTemp, minTemp) - worldTemp) / 2.0, 0.23, 0.5);
        this.setArgument("strength", CSMath.clamp(strength + addAmount, 0.0, maxStrength));
        if (strength <= 0.0) {
            this.expires(this.getTicksExisted() - 1);
        }
        if (!player.m_20069_() && Math.random() < Math.min(0.5, strength)) {
            double randX = (double)player.m_20205_() * (Math.random() - 0.5);
            double randY = (double)player.m_20192_() * 0.8 * Math.random();
            double randZ = (double)player.m_20205_() * (Math.random() - 0.5);
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, player.m_20185_() + randX, player.m_20186_() + randY, player.m_20189_() + randZ, 0.0, 0.0, 0.0);
        }
        return temp -> temp.add(-((Double)this.getArgument("strength")).doubleValue());
    }

    @Override
    public String getID() {
        return "cold_sweat:water";
    }
}

