/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.temperature.modifier.compat;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonsTempModifier
extends TempModifier {
    @Override
    public Function<Temperature, Temperature> calculate(Player player) {
        if (player.f_19853_.m_6042_().m_63956_()) {
            double endValue;
            double startValue;
            ISeasonState season = SeasonHelper.getSeasonState((Level)player.f_19853_);
            switch (season.getSubSeason()) {
                case EARLY_AUTUMN: {
                    startValue = ConfigSettings.AUTUMN_TEMPS.get()[0];
                    endValue = ConfigSettings.AUTUMN_TEMPS.get()[1];
                    break;
                }
                case MID_AUTUMN: {
                    startValue = ConfigSettings.AUTUMN_TEMPS.get()[1];
                    endValue = ConfigSettings.AUTUMN_TEMPS.get()[2];
                    break;
                }
                case LATE_AUTUMN: {
                    startValue = ConfigSettings.AUTUMN_TEMPS.get()[2];
                    endValue = ConfigSettings.WINTER_TEMPS.get()[0];
                    break;
                }
                case EARLY_WINTER: {
                    startValue = ConfigSettings.WINTER_TEMPS.get()[0];
                    endValue = ConfigSettings.WINTER_TEMPS.get()[1];
                    break;
                }
                case MID_WINTER: {
                    startValue = ConfigSettings.WINTER_TEMPS.get()[1];
                    endValue = ConfigSettings.WINTER_TEMPS.get()[2];
                    break;
                }
                case LATE_WINTER: {
                    startValue = ConfigSettings.WINTER_TEMPS.get()[2];
                    endValue = ConfigSettings.SPRING_TEMPS.get()[0];
                    break;
                }
                case EARLY_SPRING: {
                    startValue = ConfigSettings.SPRING_TEMPS.get()[0];
                    endValue = ConfigSettings.SPRING_TEMPS.get()[1];
                    break;
                }
                case MID_SPRING: {
                    startValue = ConfigSettings.SPRING_TEMPS.get()[1];
                    endValue = ConfigSettings.SPRING_TEMPS.get()[2];
                    break;
                }
                case LATE_SPRING: {
                    startValue = ConfigSettings.SPRING_TEMPS.get()[2];
                    endValue = ConfigSettings.SUMMER_TEMPS.get()[0];
                    break;
                }
                case EARLY_SUMMER: {
                    startValue = ConfigSettings.SUMMER_TEMPS.get()[0];
                    endValue = ConfigSettings.SUMMER_TEMPS.get()[1];
                    break;
                }
                case MID_SUMMER: {
                    startValue = ConfigSettings.SUMMER_TEMPS.get()[1];
                    endValue = ConfigSettings.SUMMER_TEMPS.get()[2];
                    break;
                }
                case LATE_SUMMER: {
                    startValue = ConfigSettings.SUMMER_TEMPS.get()[2];
                    endValue = ConfigSettings.AUTUMN_TEMPS.get()[0];
                    break;
                }
                default: {
                    return temp -> temp;
                }
            }
            return temp -> temp.add((float)CSMath.blend(startValue, endValue, (double)(season.getDay() % (season.getSubSeasonDuration() / season.getDayDuration())), 0.0, 8.0));
        }
        return temp -> temp;
    }

    @Override
    public String getID() {
        return "sereneseasons:season";
    }
}

