/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.api.util;

import dev.momostudios.coldsweat.ColdSweat;
import dev.momostudios.coldsweat.api.event.common.TempModifierEvent;
import dev.momostudios.coldsweat.api.registry.TempModifierRegistry;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.TempModifier;
import dev.momostudios.coldsweat.common.capability.ITemperatureCap;
import dev.momostudios.coldsweat.common.capability.ModCapabilities;
import dev.momostudios.coldsweat.common.capability.PlayerTempCap;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.PlayerModifiersSyncMessage;
import dev.momostudios.coldsweat.core.network.message.PlayerTempSyncMessage;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.math.InterruptableStreamer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TempHelper {
    public static Temperature getTemperature(Player player, Temperature.Type type) {
        return new Temperature(((ITemperatureCap)player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).orElse((Object)new PlayerTempCap())).getTemp(type));
    }

    public static void setTemperature(Player player, Temperature value, Temperature.Type type) {
        ((ITemperatureCap)player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).orElse((Object)new PlayerTempCap())).setTemp(type, value.get());
    }

    public static void addTemperature(Player player, Temperature value, Temperature.Type type) {
        player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> cap.setTemp(type, value.add(cap.getTemp(type)).get()));
    }

    public static boolean hasModifier(Player player, Temperature.Type type, Class<? extends TempModifier> modClass) {
        return player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).map(cap -> cap.hasModifier(type, modClass)).orElse(false);
    }

    @Nullable
    public static <T extends TempModifier> T getModifier(Player player, Temperature.Type type, Class<T> modClass) {
        AtomicReference<Object> mod = new AtomicReference<Object>(null);
        for (TempModifier modifier : ((ITemperatureCap)player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).orElse((Object)new PlayerTempCap())).getModifiers(type)) {
            if (!modifier.getClass().equals(modClass)) continue;
            mod.set(modifier);
            break;
        }
        return (T)((TempModifier)mod.get());
    }

    @Nullable
    public static TempModifier getModifier(Player player, Temperature.Type type, Predicate<TempModifier> condition) {
        for (TempModifier modifier : ((ITemperatureCap)player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).orElse((Object)new PlayerTempCap())).getModifiers(type)) {
            if (!condition.test(modifier)) continue;
            return modifier;
        }
        return null;
    }

    public static void addModifier(Player player, TempModifier modifier, Temperature.Type type, boolean allowDuplicates) {
        TempHelper.addModifier(player, modifier, type, allowDuplicates ? Integer.MAX_VALUE : 1, false);
    }

    public static void replaceModifier(Player player, TempModifier modifier, Temperature.Type type) {
        TempHelper.addModifier(player, modifier, type, 1, true);
    }

    public static void addModifier(Player player, TempModifier modifier, Temperature.Type type, int maxCount, boolean replace) {
        TempModifierEvent.Add event = new TempModifierEvent.Add(modifier, player, type, maxCount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            TempModifier newModifier = event.getModifier();
            if (TempModifierRegistry.getEntries().containsKey((Object)newModifier.getID())) {
                player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
                    List<TempModifier> modifiers = cap.getModifiers(event.type);
                    List<TempModifier> matchingMods = modifiers.stream().filter(mod -> mod.getID().equals(newModifier.getID())).toList();
                    int matchingCount = matchingMods.size();
                    if (matchingCount >= event.maxCount) {
                        if (replace) {
                            modifiers.removeAll(matchingMods.stream().limit(matchingMods.size() - (event.maxCount - 1)).toList());
                            matchingCount = 0;
                        } else {
                            return;
                        }
                    }
                    if (matchingCount < event.maxCount) {
                        modifiers.add(event.getModifier());
                        TempHelper.updateModifiers(player, cap);
                    }
                });
            } else {
                ColdSweat.LOGGER.error("Tried to reference invalid TempModifier with ID \"" + modifier.getID() + "\"! Is it not registered?");
            }
        }
    }

    public static void removeModifiers(Player player, Temperature.Type type, int count, Predicate<TempModifier> condition) {
        AtomicInteger removed = new AtomicInteger(0);
        player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
            cap.getModifiers(type).removeIf(modifier -> {
                if (removed.get() < count) {
                    TempModifierEvent.Remove event = new TempModifierEvent.Remove(player, type, count, condition);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled() && event.getCondition().test((TempModifier)modifier)) {
                        removed.incrementAndGet();
                        return true;
                    }
                    return false;
                }
                return false;
            });
            if (removed.get() > 0) {
                TempHelper.updateModifiers(player, cap);
            }
        });
    }

    public static void removeModifiers(Player player, Temperature.Type type, Predicate<TempModifier> condition) {
        TempHelper.removeModifiers(player, type, Integer.MAX_VALUE, condition);
    }

    public static List<TempModifier> getModifiers(Player player, Temperature.Type type) {
        return player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).map(cap -> cap.getModifiers(type)).orElse(null);
    }

    public static boolean hasModifier(Player player, Class<? extends TempModifier> modClass, Temperature.Type type) {
        return player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).map(cap -> cap.hasModifier(type, modClass)).orElse(false);
    }

    public static void forEachModifier(Player player, Temperature.Type type, Consumer<TempModifier> action) {
        player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
            if (cap.getModifiers(type) != null) {
                cap.getModifiers(type).forEach(action);
            }
        });
    }

    public static void forEachModifier(Player player, Temperature.Type type, BiConsumer<TempModifier, InterruptableStreamer<TempModifier>> action) {
        player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
            if (cap.getModifiers(type) != null) {
                CSMath.breakableForEach(cap.getModifiers(type), action);
            }
        });
    }

    public static String getModifierTag(Temperature.Type type) {
        return switch (type) {
            case Temperature.Type.CORE -> "coreTempModifiers";
            case Temperature.Type.WORLD -> "worldTempModifiers";
            case Temperature.Type.BASE -> "baseTempModifiers";
            case Temperature.Type.RATE -> "rateTempModifiers";
            case Temperature.Type.MAX -> "maxTempModifiers";
            case Temperature.Type.MIN -> "minTempModifiers";
            default -> throw new IllegalArgumentException("PlayerTempHandler.getModifierTag(): \"" + type + "\" is not a valid type!");
        };
    }

    public static String getTempTag(Temperature.Type type) {
        return switch (type) {
            case Temperature.Type.CORE -> "coreTemp";
            case Temperature.Type.WORLD -> "worldTemp";
            case Temperature.Type.BASE -> "baseTemp";
            case Temperature.Type.MAX -> "maxWorldTemp";
            case Temperature.Type.MIN -> "minWorldTemp";
            default -> throw new IllegalArgumentException("PlayerTempHandler.getTempTag(): \"" + type + "\" is not a valid type!");
        };
    }

    public static void updateTemperature(Player player, ITemperatureCap cap, boolean instant) {
        if (!player.f_19853_.f_46443_ && cap instanceof PlayerTempCap) {
            PlayerTempCap playerCap = (PlayerTempCap)cap;
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayerTempSyncMessage(playerCap.serializeTemps(), instant));
        }
    }

    public static void updateModifiers(Player player, ITemperatureCap cap) {
        if (!player.f_19853_.f_46443_ && cap instanceof PlayerTempCap) {
            PlayerTempCap playerCap = (PlayerTempCap)cap;
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayerModifiersSyncMessage(playerCap.serializeModifiers()));
        }
    }
}

