/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.event;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.config.ClientSettingsConfig;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ItemTooltipInfo {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void addTTInfo(ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() == ModItems.FILLED_WATERSKIN && event.getPlayer() != null) {
            boolean celsius = ClientSettingsConfig.getInstance().celsius();
            double temp = event.getItemStack().m_41784_().m_128459_("temperature");
            String color = temp == 0.0 ? "7" : (temp < 0.0 ? "9" : "c");
            String tempUnits = celsius ? "C" : "F";
            temp = temp / 2.0 + 95.0;
            if (celsius) {
                temp = CSMath.convertUnits(temp, Temperature.Units.F, Temperature.Units.C, true);
            }
            event.getToolTip().add(1, new TextComponent("\u00a77" + new TranslatableComponent("item.cold_sweat.waterskin.filled").getString() + " (\u00a7" + color + (int)(temp += (double)ClientSettingsConfig.getInstance().tempOffset() / 2.0) + " \u00b0" + tempUnits + "\u00a77)\u00a7r"));
        } else if (event.getItemStack().m_41720_() instanceof ArmorItem && event.getItemStack().m_41784_().m_128471_("insulated")) {
            event.getToolTip().add(1, new TextComponent("\u00a7d" + new TranslatableComponent("modifier.cold_sweat.insulated").getString() + "\u00a7r"));
        } else if (event.getItemStack().m_41720_() == ModItems.SOULSPRING_LAMP) {
            event.getToolTip().add(1, new TextComponent("             "));
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                event.getToolTip().add(Math.max(event.getToolTip().size() - 2, 2), new TextComponent("\u00a7fFuel: " + (int)event.getItemStack().m_41784_().m_128459_("fuel") + " / 64"));
            }
        }
    }
}

