/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.common.capability.ITemperatureCap;
import dev.momostudios.coldsweat.common.capability.ModCapabilities;
import dev.momostudios.coldsweat.common.capability.PlayerTempCap;
import dev.momostudios.coldsweat.config.ClientSettingsConfig;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Overlays {
    public static ITemperatureCap PLAYER_CAP = new PlayerTempCap();
    static boolean SHOW_WORLD_TEMP = false;
    static double PREV_WORLD_TEMP = 0.0;
    public static double WORLD_TEMP = 0.0;
    static double MAX_OFFSET = 0.0;
    static double MIN_OFFSET = 0.0;
    static boolean SHOW_BODY_TEMP = false;
    static double BODY_TEMP = 0.0;
    static double PREV_BODY_TEMP = 0.0;
    static int BLEND_BODY_TEMP = 0;
    static int ICON_BOB = 0;
    static int BODY_ICON = 0;
    static int PREV_BODY_ICON = 0;
    static int BODY_TRANSITION_PROGRESS = 0;
    static int BODY_BLEND_TIME = 10;
    static int BODY_TEMP_SEVERITY = 0;
    static ClientSettingsConfig CLIENT_CONFIG = ClientSettingsConfig.getInstance();
    public static final IIngameOverlay WORLD_TEMP_ELEMENT = OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.CHAT_PANEL_ELEMENT, (String)"World Temp", (gui, poseStack, partialTick, width, height) -> {
        gui.setupOverlayRenderState(true, false);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && SHOW_WORLD_TEMP) {
            double min = ConfigSettings.getInstance().minTemp + MIN_OFFSET;
            double max = ConfigSettings.getInstance().maxTemp + MAX_OFFSET;
            double temp = CSMath.convertUnits(WORLD_TEMP, CLIENT_CONFIG.celsius() ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getWorldSeverity(temp, min, max);
            int color = switch (severity) {
                case 2, 3 -> 16297781;
                case 4 -> 16728089;
                case -3, -2 -> 8443135;
                case -4 -> 4236031;
                default -> 14737376;
            };
            poseStack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge.png"));
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(width / 2 + 94 + CLIENT_CONFIG.worldGaugeX()), (int)(height - 19 + CLIENT_CONFIG.worldGaugeY()), (float)0.0f, (float)(64 - severity * 16), (int)25, (int)16, (int)25, (int)144);
            RenderSystem.m_69461_();
            int bob = CLIENT_CONFIG.iconBobbing() && !CSMath.isInRange(temp, min, max) && player.f_19797_ % 2 == 0 ? 1 : 0;
            int blendedTemp = (int)CSMath.blend(PREV_WORLD_TEMP, WORLD_TEMP, (double)Minecraft.m_91087_().m_91296_(), 0.0, 1.0);
            Minecraft.m_91087_().f_91062_.m_92883_(poseStack, "" + (blendedTemp + CLIENT_CONFIG.tempOffset()), (float)width / 2.0f + 107.0f + (float)(Integer.toString(blendedTemp + CLIENT_CONFIG.tempOffset()).length() * -3) + (float)CLIENT_CONFIG.worldGaugeX(), (float)(height - 15 - bob + CLIENT_CONFIG.worldGaugeY()), color);
            poseStack.m_85849_();
        }
    });
    public static final IIngameOverlay BODY_TEMP_ELEMENT = OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.CHAT_PANEL_ELEMENT, (String)"Body Temp", (gui, poseStack, partialTick, width, height) -> {
        gui.setupOverlayRenderState(true, false);
        Minecraft mc = Minecraft.m_91087_();
        Entity patt5208$temp = mc.f_91075_;
        if (patt5208$temp instanceof Player) {
            Player player = (Player)patt5208$temp;
            if (SHOW_BODY_TEMP) {
                int color;
                BLEND_BODY_TEMP = (int)CSMath.blend(PREV_BODY_TEMP, BODY_TEMP, (double)Minecraft.m_91087_().m_91296_(), 0.0, 1.0);
                switch (BODY_TEMP_SEVERITY) {
                    case -7: 
                    case 7: {
                        int n = 0xFFFFFF;
                        break;
                    }
                    case 6: {
                        int n = 0xFFFFAC;
                        break;
                    }
                    case 5: {
                        int n = 16767856;
                        break;
                    }
                    case 4: {
                        int n = 16759634;
                        break;
                    }
                    case 3: {
                        int n = 16751174;
                        break;
                    }
                    case -3: {
                        int n = 6078975;
                        break;
                    }
                    case -4: {
                        int n = 7528447;
                        break;
                    }
                    case -5: {
                        int n = 0x84F4FF;
                        break;
                    }
                    case -6: {
                        int n = 0xB0FFFF;
                        break;
                    }
                    default: {
                        int n = BLEND_BODY_TEMP > 0 ? 16744509 : (color = BLEND_BODY_TEMP < 0 ? 4233468 : 0xAFAFAF);
                    }
                }
                int colorBG = BLEND_BODY_TEMP < 0 ? 1122643 : (BLEND_BODY_TEMP > 0 ? 5376516 : 0);
                int bobLevel = Math.min(Math.abs(BODY_TEMP_SEVERITY), 3);
                int threatOffset = !CLIENT_CONFIG.iconBobbing() ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? player.f_19797_ % 2 : 0));
                RenderSystem.m_69453_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge.png"));
                if (BODY_TRANSITION_PROGRESS < BODY_BLEND_TIME) {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)(width / 2 - 5 + CLIENT_CONFIG.bodyIconX()), (int)(height - 53 - threatOffset + CLIENT_CONFIG.bodyIconY()), (float)0.0f, (float)(30 - PREV_BODY_ICON * 10), (int)10, (int)10, (int)10, (int)70);
                    RenderSystem.m_69478_();
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((mc.m_91296_() + (float)BODY_TRANSITION_PROGRESS) / (float)BODY_BLEND_TIME));
                }
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(width / 2 - 5 + CLIENT_CONFIG.bodyIconX()), (int)(height - 53 - threatOffset + CLIENT_CONFIG.bodyIconY()), (float)0.0f, (float)(30 - BODY_ICON * 10), (int)10, (int)10, (int)10, (int)70);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Font font = mc.f_91062_;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                String s = "" + Math.min(Math.abs(BLEND_BODY_TEMP), 100);
                float x = (float)(scaledWidth - font.m_92895_(s)) / 2.0f + (float)CLIENT_CONFIG.bodyReadoutX();
                float y = (float)scaledHeight - 31.0f - 10.0f + (float)CLIENT_CONFIG.bodyReadoutY();
                font.m_92883_(poseStack, s, x + 1.0f, y, colorBG);
                font.m_92883_(poseStack, s, x - 1.0f, y, colorBG);
                font.m_92883_(poseStack, s, x, y + 1.0f, colorBG);
                font.m_92883_(poseStack, s, x, y - 1.0f, colorBG);
                font.m_92883_(poseStack, s, x, y, color);
            }
        }
    });

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity entity;
        if (event.phase == TickEvent.Phase.START && (entity = Minecraft.m_91087_().f_91075_) instanceof Player) {
            Player player = (Player)entity;
            if (PLAYER_CAP == null || player.f_19797_ % 40 == 0) {
                PLAYER_CAP = (ITemperatureCap)player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).orElse(null);
            }
            if (SHOW_WORLD_TEMP) {
                boolean celsius = CLIENT_CONFIG.celsius();
                double realTemp = CSMath.convertUnits(PLAYER_CAP.getTemp(Temperature.Type.WORLD), Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true);
                PREV_WORLD_TEMP = WORLD_TEMP;
                WORLD_TEMP += (realTemp - WORLD_TEMP) / 6.0;
                MAX_OFFSET = PLAYER_CAP.getTemp(Temperature.Type.MAX);
                MIN_OFFSET = PLAYER_CAP.getTemp(Temperature.Type.MIN);
            }
            PREV_BODY_TEMP = BODY_TEMP;
            BODY_TEMP += (PLAYER_CAP.getTemp(Temperature.Type.BODY) - BODY_TEMP) / 5.0;
            if (SHOW_BODY_TEMP) {
                ICON_BOB = player.f_19797_ % 3 == 0 && Math.random() < 0.3 ? 1 : 0;
                BODY_TEMP_SEVERITY = Overlays.getBodySeverity(BLEND_BODY_TEMP);
                int neededIcon = CSMath.clamp(BODY_TEMP_SEVERITY, -3, 3);
                if (BODY_ICON != neededIcon) {
                    BODY_ICON = neededIcon;
                    BODY_TRANSITION_PROGRESS = 0;
                }
                if (PREV_BODY_ICON != BODY_ICON && BODY_TRANSITION_PROGRESS++ >= BODY_BLEND_TIME) {
                    PREV_BODY_ICON = BODY_ICON;
                }
            }
        }
    }

    @SubscribeEvent
    public static void updateDisplayCondition(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            SHOW_WORLD_TEMP = !ConfigSettings.getInstance().requireThermometer || player.m_150109_().f_35974_.stream().limit(9L).anyMatch(stack -> stack.m_41720_() == ModItems.THERMOMETER) || player.m_21206_().m_41720_() == ModItems.THERMOMETER;
            SHOW_BODY_TEMP = !player.m_7500_() && !player.m_5833_();
        }
    }

    static int getWorldSeverity(double temp, double min, double max) {
        return (int)CSMath.blend(-4.0, 4.0, temp, min, max);
    }

    static int getBodySeverity(int temp) {
        int sign = CSMath.getSign(temp);
        int absTemp = Math.abs(temp);
        return absTemp < 100 ? (int)Math.floor(CSMath.blend(0.0f, 3.0f, absTemp, 0.0f, 100.0f)) * sign : (int)CSMath.blend(3.0f, 7.0f, absTemp, 100.0f, 150.0f) * sign;
    }

    public static void setBodyTemp(double temp) {
        BODY_TEMP = temp;
        PREV_BODY_TEMP = temp;
        BLEND_BODY_TEMP = (int)temp;
    }
}

