/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.gui.config;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TranslatableComponent;

public class DifficultyDescriptions {
    private static final String bl = ChatFormatting.BLUE.toString();
    private static final String rd = ChatFormatting.RED.toString();
    private static final String ye = ChatFormatting.YELLOW.toString();
    private static final String rs = ChatFormatting.RESET.toString();
    private static final String bold = ChatFormatting.BOLD.toString();
    private static final String under = ChatFormatting.UNDERLINE.toString();

    public static List<String> getListFor(int difficulty) {
        switch (difficulty) {
            case 0: {
                return DifficultyDescriptions.superEasyDescription();
            }
            case 1: {
                return DifficultyDescriptions.easyDescription();
            }
            case 2: {
                return DifficultyDescriptions.normalDescription();
            }
            case 3: {
                return DifficultyDescriptions.hardDescription();
            }
        }
        return DifficultyDescriptions.customDescription();
    }

    public static List<String> superEasyDescription() {
        return Arrays.asList(DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.min_temp", DifficultyDescriptions.getTemp(40.0, bl)), DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.max_temp", DifficultyDescriptions.getTemp(120.0, rd)), DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.rate.decrease", ye + "50%" + rs), new TranslatableComponent("cold_sweat.config.difficulty.description.world_temp_on", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.scaling_off", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.potions_on", new Object[]{bold + under, rs}).getString());
    }

    public static List<String> easyDescription() {
        return Arrays.asList(DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.min_temp", DifficultyDescriptions.getTemp(45.0, bl)), DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.max_temp", DifficultyDescriptions.getTemp(110.0, rd)), DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.rate.decrease", ye + "25%" + rs), new TranslatableComponent("cold_sweat.config.difficulty.description.world_temp_on", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.scaling_off", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.potions_on", new Object[]{bold + under, rs}).getString());
    }

    public static List<String> normalDescription() {
        return Arrays.asList(DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.min_temp", DifficultyDescriptions.getTemp(50.0, bl)), DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.max_temp", DifficultyDescriptions.getTemp(100.0, rd)), new TranslatableComponent("cold_sweat.config.difficulty.description.rate.normal").getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.world_temp_off", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.scaling_on", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.potions_off", new Object[]{bold + under, rs}).getString());
    }

    public static List<String> hardDescription() {
        return Arrays.asList(DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.min_temp", DifficultyDescriptions.getTemp(60.0, bl)), DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.max_temp", DifficultyDescriptions.getTemp(90.0, rd)), DifficultyDescriptions.getTrans("cold_sweat.config.difficulty.description.rate.increase", ye + "50%" + rs), new TranslatableComponent("cold_sweat.config.difficulty.description.world_temp_off", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.scaling_on", new Object[]{bold + under, rs}).getString(), new TranslatableComponent("cold_sweat.config.difficulty.description.potions_off", new Object[]{bold + under, rs}).getString());
    }

    public static List<String> customDescription() {
        return Collections.singletonList(new TranslatableComponent("cold_sweat.config.difficulty.description.custom").getString());
    }

    private static String getTrans(String key, Object ... args) {
        return new TranslatableComponent(key, args).getString();
    }

    private static String getTemp(double temp, String color) {
        DecimalFormat df = new DecimalFormat("#.##");
        return color + temp + rs + " \u00b0F / " + color + df.format(CSMath.convertUnits(temp, Temperature.Units.F, Temperature.Units.C, true)) + rs + " \u00b0C";
    }
}

