/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.client.gui.config.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.client.gui.config.ConfigScreen;
import dev.momostudios.coldsweat.client.gui.config.DifficultyDescriptions;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class ConfigPageDifficulty
extends Screen {
    private final Screen parentScreen;
    private final ConfigSettings configSettings;
    private static final int TITLE_HEIGHT = 16;
    private static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    private static final int BOTTOM_BUTTON_WIDTH = 150;
    ResourceLocation configButtons = new ResourceLocation("cold_sweat:textures/gui/screen/configs/config_gui.png");

    public ConfigPageDifficulty(Screen parentScreen, ConfigSettings configSettings) {
        super((Component)new TranslatableComponent("cold_sweat.config.section.difficulty.name"));
        this.parentScreen = parentScreen;
        this.configSettings = configSettings;
    }

    public int index() {
        return -1;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 26, 150, 20, (Component)new TranslatableComponent("gui.done"), button -> this.close()));
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_.f_91073_ != null) {
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        } else {
            this.m_96626_(0);
        }
        ArrayList<TextComponent> descLines = new ArrayList<TextComponent>();
        descLines.add(new TextComponent(""));
        int longestLine = 0;
        for (String text : DifficultyDescriptions.getListFor(this.configSettings.difficulty)) {
            String ttLine = "  " + text + "  ";
            descLines.add(new TextComponent(ttLine));
            descLines.add(new TextComponent(""));
            int lineWidth = this.f_96547_.m_92895_(ttLine);
            if (lineWidth <= longestLine) continue;
            longestLine = lineWidth;
        }
        int middleX = this.f_96543_ / 2;
        int middleY = this.f_96544_ / 2;
        this.renderTooltip(poseStack, descLines, ItemStack.f_41583_.m_150921_(), middleX - longestLine / 2 - 10, middleY - 16, this.f_96547_);
        ConfigScreen.MOUSE_X = mouseX;
        ConfigScreen.MOUSE_Y = mouseY;
        ConfigPageDifficulty.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)16, (int)0xFFFFFF);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.configButtons);
        this.m_93228_(poseStack, this.f_96543_ / 2 - 76, this.f_96544_ / 2 - 53, 12, this.isMouseOverSlider(mouseX, mouseY) ? 134 : 128, 152, 6);
        this.m_93228_(poseStack, this.f_96543_ / 2 - 78 + this.configSettings.difficulty * 37, this.f_96544_ / 2 - 58, this.isMouseOverSlider(mouseX, mouseY) ? 6 : 0, 128, 6, 16);
        String difficultyName = ConfigScreen.difficultyName(this.configSettings.difficulty);
        this.f_96547_.m_92750_(poseStack, difficultyName, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(difficultyName) / 2.0f, (float)this.f_96544_ / 2.0f - 84.0f, ConfigScreen.difficultyColor(this.configSettings.difficulty));
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private void close() {
        if (this.configSettings.difficulty == 0) {
            this.configSettings.minTemp = CSMath.convertUnits(40.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.maxTemp = CSMath.convertUnits(120.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.rate = 0.5;
            this.configSettings.requireThermometer = false;
            this.configSettings.damageScaling = false;
            this.configSettings.fireRes = true;
            this.configSettings.iceRes = true;
        } else if (this.configSettings.difficulty == 1) {
            this.configSettings.minTemp = CSMath.convertUnits(45.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.maxTemp = CSMath.convertUnits(110.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.rate = 0.75;
            this.configSettings.requireThermometer = false;
            this.configSettings.damageScaling = false;
            this.configSettings.fireRes = true;
            this.configSettings.iceRes = true;
        } else if (this.configSettings.difficulty == 2) {
            this.configSettings.minTemp = CSMath.convertUnits(50.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.maxTemp = CSMath.convertUnits(100.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.rate = 1.0;
            this.configSettings.requireThermometer = true;
            this.configSettings.damageScaling = true;
            this.configSettings.fireRes = false;
            this.configSettings.iceRes = false;
        } else if (this.configSettings.difficulty == 3) {
            this.configSettings.minTemp = CSMath.convertUnits(60.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.maxTemp = CSMath.convertUnits(90.0, Temperature.Units.F, Temperature.Units.MC, true);
            this.configSettings.rate = 1.5;
            this.configSettings.requireThermometer = true;
            this.configSettings.damageScaling = true;
            this.configSettings.fireRes = false;
            this.configSettings.iceRes = false;
        }
        ConfigScreen.saveConfig(this.configSettings);
        ConfigScreen.MC.m_91152_(this.parentScreen);
    }

    boolean isMouseOverSlider(double mouseX, double mouseY) {
        return mouseX >= (double)this.f_96543_ / 2.0 - 80.0 && mouseX <= (double)this.f_96543_ / 2.0 + 80.0 && mouseY >= (double)this.f_96544_ / 2.0 - 67.0 && mouseY <= (double)this.f_96544_ / 2.0 - 35.0;
    }

    public void m_96624_() {
        double x = ConfigScreen.MOUSE_X;
        double y = ConfigScreen.MOUSE_Y;
        if (ConfigScreen.IS_MOUSE_DOWN && this.isMouseOverSlider(x, y)) {
            int newDifficulty = 0;
            if (x < (double)this.f_96543_ / 2.0 - 76.0 + 19.0) {
                newDifficulty = 0;
            } else if (x < (double)this.f_96543_ / 2.0 - 76.0 + 57.0) {
                newDifficulty = 1;
            } else if (x < (double)this.f_96543_ / 2.0 - 76.0 + 95.0) {
                newDifficulty = 2;
            } else if (x < (double)this.f_96543_ / 2.0 - 76.0 + 133.0) {
                newDifficulty = 3;
            } else if (x < (double)this.f_96543_ / 2.0 - 76.0 + 171.0) {
                newDifficulty = 4;
            }
            if (newDifficulty != this.configSettings.difficulty) {
                ConfigScreen.MC.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)new SoundEvent(new ResourceLocation("minecraft:block.note_block.hat")), (float)1.8f, (float)0.5f));
            }
            this.configSettings.difficulty = newDifficulty;
        }
    }
}

