/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.block;

import dev.momostudios.coldsweat.common.block.HearthTopBlock;
import dev.momostudios.coldsweat.common.blockentity.HearthBlockEntity;
import dev.momostudios.coldsweat.core.itemgroup.ColdSweatGroup;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModBlockEntities;
import dev.momostudios.coldsweat.util.registries.ModBlocks;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class HearthBottomBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty WATER = IntegerProperty.m_61631_((String)"water", (int)0, (int)2);
    public static final IntegerProperty LAVA = IntegerProperty.m_61631_((String)"lava", (int)0, (int)2);
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_155954_(2.0f).m_155956_(10.0f).m_60999_().m_60955_().m_60988_().m_60953_(state -> (Integer)state.m_61143_((Property)LAVA) * 3);
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(1);
    }

    public HearthBottomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATER, (Comparable)Integer.valueOf(0))).m_61124_((Property)LAVA, (Comparable)Integer.valueOf(0)));
        HearthBottomBlock.calculateFacingShapes(Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.5, (double)13.0, (double)18.0, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)18.0, (double)5.0, (double)9.0, (double)27.0, (double)10.0), Block.m_49796_((double)-1.0, (double)3.0, (double)6.0, (double)17.0, (double)11.0, (double)10.0)}));
    }

    static void calculateFacingShapes(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            SHAPES.put(direction, CSMath.rotateShape(direction, shape));
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.HEARTH ? HearthBlockEntity::tickSelf : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HearthBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity;
        if (!worldIn.f_46443_ && (blockEntity = worldIn.m_7702_(pos)) instanceof HearthBlockEntity) {
            int itemFuel;
            int hearthFuel;
            HearthBlockEntity te = (HearthBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (player.m_21120_(hand).m_41720_() == Items.f_42446_) {
                int lavaFuel = Math.abs(HearthBlockEntity.getItemFuel(Items.f_42448_.m_7968_()));
                if ((double)te.getHotFuel() >= (double)lavaFuel * 0.99) {
                    Vec3i lavaSideOffset = ((Direction)state.m_61143_((Property)FACING)).m_122427_().m_122436_();
                    Vec3 lavaSidePos = CSMath.getMiddle(pos).m_82520_((double)lavaSideOffset.m_123341_() * 0.65, (double)lavaSideOffset.m_123342_() * 0.65, (double)lavaSideOffset.m_123343_() * 0.65);
                    if (rayTraceResult.m_82450_().m_82554_(lavaSidePos) < 0.4 && lavaFuel > 0) {
                        te.setHotFuel(te.getHotFuel() - lavaFuel);
                        if (stack.m_41613_() == 1) {
                            player.m_21008_(hand, Items.f_42448_.m_7968_());
                        } else {
                            stack.m_41774_(1);
                            player.m_36356_(Items.f_42448_.m_7968_());
                        }
                        worldIn.m_5594_(null, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
                        return InteractionResult.SUCCESS;
                    }
                }
                int waterFuel = Math.abs(HearthBlockEntity.getItemFuel(Items.f_42447_.m_7968_()));
                if ((double)te.getColdFuel() >= (double)waterFuel * 0.99) {
                    Vec3i waterSideOffset = ((Direction)state.m_61143_((Property)FACING)).m_122428_().m_122436_();
                    Vec3 waterSidePos = CSMath.getMiddle(pos).m_82520_((double)waterSideOffset.m_123341_() * 0.65, (double)waterSideOffset.m_123342_() * 0.65, (double)waterSideOffset.m_123343_() * 0.65);
                    if (rayTraceResult.m_82450_().m_82554_(waterSidePos) < 0.4 && waterFuel > 0) {
                        te.setColdFuel(te.getColdFuel() - waterFuel);
                        if (stack.m_41613_() == 1) {
                            player.m_21008_(hand, Items.f_42447_.m_7968_());
                        } else {
                            stack.m_41774_(1);
                            player.m_36356_(Items.f_42447_.m_7968_());
                        }
                        worldIn.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            int n = hearthFuel = (itemFuel = HearthBlockEntity.getItemFuel(stack)) > 0 ? te.getHotFuel() : te.getColdFuel();
            if (itemFuel != 0 && (double)hearthFuel + (double)Math.abs(itemFuel) * 0.75 < 1000.0) {
                if (!player.m_7500_()) {
                    if (stack.hasContainerItem()) {
                        ItemStack container = stack.getContainerItem();
                        player.m_21008_(hand, container);
                    } else {
                        stack.m_41774_(1);
                    }
                }
                te.addFuel(itemFuel);
                worldIn.m_5594_(null, pos, itemFuel > 0 ? SoundEvents.f_11780_ : SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
            } else {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)te, (BlockPos)pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState lastState, boolean p_60570_) {
        if (level.m_8055_(pos.m_7494_()).m_60795_()) {
            level.m_7731_(pos.m_7494_(), (BlockState)ModBlocks.HEARTH_TOP.m_49966_().m_61124_((Property)HearthTopBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 2);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (level.m_8055_(pos.m_7494_()).m_60734_() != ModBlocks.HEARTH_TOP) {
            this.m_6786_((LevelAccessor)level, pos, state);
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List dropsOriginal = super.m_7381_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity;
            if (level.m_8055_(pos.m_7494_()).m_60734_() == ModBlocks.HEARTH_TOP) {
                level.m_46961_(pos.m_7494_(), false);
            }
            if ((tileentity = level.m_7702_(pos)) instanceof HearthBlockEntity) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((HearthBlockEntity)tileentity));
                level.m_46672_(pos, (Block)this);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATER, LAVA});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos topPos;
        Level level = context.m_43725_();
        return level.m_8055_(topPos = context.m_8083_().m_7494_()).m_60629_(context) && level.m_6857_().m_61937_(topPos) ? (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATER, (Comparable)Integer.valueOf(0))).m_61124_((Property)LAVA, (Comparable)Integer.valueOf(0)) : null;
    }
}

