/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.blockentity;

import com.mojang.datafixers.util.Pair;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.HearthTempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.common.block.HearthBottomBlock;
import dev.momostudios.coldsweat.common.container.HearthContainer;
import dev.momostudios.coldsweat.common.event.HearthPathManagement;
import dev.momostudios.coldsweat.config.ClientSettingsConfig;
import dev.momostudios.coldsweat.core.init.BlockEntityInit;
import dev.momostudios.coldsweat.core.init.ParticleTypesInit;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.BlockDataUpdateMessage;
import dev.momostudios.coldsweat.core.network.message.HearthResetMessage;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModEffects;
import dev.momostudios.coldsweat.util.registries.ModSounds;
import dev.momostudios.coldsweat.util.world.SpreadPath;
import dev.momostudios.coldsweat.util.world.WorldHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;

public class HearthBlockEntity
extends RandomizableContainerBlockEntity {
    ConfigSettings config = ConfigSettings.getInstance();
    ArrayList<SpreadPath> paths = new ArrayList();
    Set<BlockPos> pathLookup = new HashSet<BlockPos>();
    HashMap<ChunkPos, LevelChunk> loadedChunks = new HashMap();
    static int INSULATION_TIME = 1200;
    public static int SLOT_COUNT = 1;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)SLOT_COUNT, (Object)ItemStack.f_41583_);
    BlockPos blockPos = this.m_58899_();
    int hotFuel = 0;
    int coldFuel = 0;
    boolean shouldUseHotFuel = false;
    boolean shouldUseColdFuel = false;
    boolean hasHotFuel = false;
    boolean hasColdFuel = false;
    int insulationLevel = 0;
    boolean isPlayerNearby = false;
    int rebuildCooldown = 0;
    boolean forceRebuild = false;
    LinkedList<BlockPos> notifyQueue = new LinkedList();
    public int ticksExisted = 0;
    private LevelChunk workingChunk = null;
    private ChunkPos workingCoords = new ChunkPos(this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4);
    boolean showParticles = true;
    int frozenPaths = 0;
    boolean spreading = true;
    public static final int MAX_FUEL = 1000;

    public HearthBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.HEARTH_BLOCK_ENTITY_TYPE.get(), pos, state);
        this.addPath(new SpreadPath(this.m_58899_()));
        HearthPathManagement.HEARTH_POSITIONS.put(this.m_58899_(), this.spreadRange());
    }

    public int spreadRange() {
        return 20;
    }

    public int maxPaths() {
        return 6000;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.cold_sweat.hearth");
    }

    public Component m_5446_() {
        return this.m_7770_() != null ? this.m_7770_() : this.m_6820_();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("hotFuel", this.getHotFuel());
        tag.m_128405_("coldFuel", this.getColdFuel());
        tag.m_128405_("insulationLevel", this.insulationLevel);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.setHotFuel(tag.m_128451_("hotFuel"));
        this.setColdFuel(tag.m_128451_("coldFuel"));
        this.insulationLevel = tag.m_128451_("insulationLevel");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public static <T extends BlockEntity> void tickSelf(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof HearthBlockEntity) {
            HearthBlockEntity hearth = (HearthBlockEntity)te;
            hearth.tick(level, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void tick(Level level, BlockPos pos) {
        block54: {
            if (this.paths.isEmpty()) {
                this.addPath(new SpreadPath(pos));
            }
            ++this.ticksExisted;
            if (this.rebuildCooldown > 0) {
                --this.rebuildCooldown;
            }
            players = new ArrayList<Player>();
            if (this.f_58857_ != null && this.ticksExisted % 20 == 0) {
                this.isPlayerNearby = false;
                for (Player player : this.f_58857_.m_6907_()) {
                    if (!player.m_142538_().m_123314_((Vec3i)pos, (double)this.spreadRange())) continue;
                    players.add(player);
                    this.isPlayerNearby = true;
                }
            }
            if (this.forceRebuild || this.rebuildCooldown <= 0 && !this.notifyQueue.isEmpty()) {
                shouldRebuild = false;
                if (this.forceRebuild) {
                    shouldRebuild = true;
                } else {
                    for (BlockPos notifyPos : this.notifyQueue) {
                        if (!this.pathLookup.contains(notifyPos)) continue;
                        shouldRebuild = true;
                        break;
                    }
                }
                if (shouldRebuild) {
                    this.rebuildCooldown = 100;
                    this.replacePaths(List.of(new SpreadPath(pos)));
                    this.frozenPaths = 0;
                    this.spreading = true;
                    if (!level.f_46443_) {
                        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with((Supplier<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$tick$0(net.minecraft.world.level.Level net.minecraft.core.BlockPos ), ()Lnet/minecraft/world/level/chunk/LevelChunk;)((Level)level, (BlockPos)pos)), (Object)new HearthResetMessage(pos));
                    }
                }
                this.notifyQueue.clear();
                this.forceRebuild = false;
            }
            if (this.hotFuel <= 0 && this.coldFuel <= 0) break block54;
            if (this.insulationLevel < HearthBlockEntity.INSULATION_TIME) {
                ++this.insulationLevel;
            }
            if (!this.isPlayerNearby) break block54;
            if (this.ticksExisted % 10 == 0) {
                this.showParticles = level.f_46443_ != false && Minecraft.m_91087_().f_91066_.f_92073_ == ParticleStatus.ALL && HearthPathManagement.DISABLED_HEARTHS.contains(Pair.of((Object)pos, (Object)level.m_46472_().m_135782_().toString())) == false;
            }
            pathCount = this.paths.size();
            partSize = CSMath.clamp(pathCount / 30, 10, 200);
            partCount = (int)CSMath.ceil((double)pathCount / (double)partSize);
            lastIndex = Math.min(pathCount, partSize * (this.ticksExisted % partCount + 1));
            block7: for (i = firstIndex = Math.max(0, lastIndex - partSize); i < Math.min(this.paths.size(), lastIndex); ++i) {
                block53: {
                    block49: {
                        block52: {
                            block50: {
                                block51: {
                                    block55: {
                                        block47: {
                                            block48: {
                                                spreadPath = this.paths.get(i);
                                                x = spreadPath.getX();
                                                y = spreadPath.getY();
                                                z = spreadPath.getZ();
                                                if (!spreadPath.isFrozen()) break block47;
                                                if (!this.spreading && Math.abs(y % 2) == 0 == (Math.abs(x % 2) == Math.abs(z % 2))) {
                                                    this.paths.remove(i);
                                                    --i;
                                                }
                                                if (!level.f_46443_ || !this.showParticles) break block48;
                                                rand = new Random();
                                                if (Minecraft.m_91087_().f_91066_.f_92063_ && ClientSettingsConfig.getInstance().hearthDebug()) break block48;
                                                v0 = rand.nextFloat();
                                                v1 = this.spreading != false ? 0.016f : 0.032f;
                                                if (v0 < v1) {
                                                    xr = rand.nextFloat();
                                                    yr = rand.nextFloat();
                                                    zr = rand.nextFloat();
                                                    xm = rand.nextFloat() / 20.0f - 0.025f;
                                                    zm = rand.nextFloat() / 20.0f - 0.025f;
                                                    level.m_6493_((ParticleOptions)ParticleTypesInit.HEARTH_AIR.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
                                                }
                                            }
                                            if (level.f_46443_) continue;
                                            for (p = 0; p < players.size(); ++p) {
                                                player = (Player)players.get(p);
                                                if (player == null || CSMath.getDistance((Vec3i)spreadPath.getPos(), (Vec3i)player.m_142538_()) > 1.0) continue;
                                                players.remove(p);
                                                --p;
                                                effect = player.m_21124_(ModEffects.INSULATION);
                                                if (effect != null && (effect.m_19557_() >= 60 || WorldHelper.canSeeSky(player.f_19853_, new BlockPos(player.m_20185_(), CSMath.ceil(player.m_20186_()), player.m_20189_()), 64))) continue;
                                                this.insulatePlayer(player);
                                                continue block7;
                                            }
                                            continue;
                                        }
                                        if (pathCount >= this.maxPaths() || !spreadPath.withinDistance((Vec3i)pos, this.spreadRange())) break block49;
                                        chunkPos = new ChunkPos(x >> 4, z >> 4);
                                        if (chunkPos != this.workingCoords) break block55;
                                        chunk = this.workingChunk;
                                        ** GOTO lbl124
                                    }
                                    chunk = this.loadedChunks.get(chunkPos);
                                    if (chunk != null) break block50;
                                    chunk = (LevelChunk)level.m_7726_().m_7587_(x >> 4, z >> 4, ChunkStatus.f_62326_, false);
                                    this.loadedChunks.put(chunkPos, chunk);
                                    if (chunk != null) break block50;
                                    if (!level.f_46443_ || !this.showParticles) break block51;
                                    rand = new Random();
                                    if (Minecraft.m_91087_().f_91066_.f_92063_ && ClientSettingsConfig.getInstance().hearthDebug()) break block51;
                                    v2 = rand.nextFloat();
                                    v3 = this.spreading != false ? 0.016f : 0.032f;
                                    if (v2 < v3) {
                                        xr = rand.nextFloat();
                                        yr = rand.nextFloat();
                                        zr = rand.nextFloat();
                                        xm = rand.nextFloat() / 20.0f - 0.025f;
                                        zm = rand.nextFloat() / 20.0f - 0.025f;
                                        level.m_6493_((ParticleOptions)ParticleTypesInit.HEARTH_AIR.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
                                    }
                                }
                                if (level.f_46443_) continue;
                                for (p = 0; p < players.size(); ++p) {
                                    player = (Player)players.get(p);
                                    if (player == null || CSMath.getDistance((Vec3i)spreadPath.getPos(), (Vec3i)player.m_142538_()) > 1.0) continue;
                                    players.remove(p);
                                    --p;
                                    effect = player.m_21124_(ModEffects.INSULATION);
                                    if (effect != null && (effect.m_19557_() >= 60 || WorldHelper.canSeeSky(player.f_19853_, new BlockPos(player.m_20185_(), CSMath.ceil(player.m_20186_()), player.m_20189_()), 64))) continue;
                                    this.insulatePlayer(player);
                                    continue block7;
                                }
                                continue;
                            }
                            this.workingCoords = chunkPos;
                            this.workingChunk = chunk;
lbl124:
                            // 2 sources

                            pathPos = spreadPath.getPos();
                            blockState = WorldHelper.getBlockState((ChunkAccess)chunk, pathPos);
                            if (!WorldHelper.canSeeSky(chunk, level, pathPos.m_7494_(), 64)) {
                                for (Direction direction : Direction.values()) {
                                    tryPath = spreadPath.offset(direction);
                                    if (!this.pathLookup.add(tryPath.getPos()) || WorldHelper.isSpreadBlocked(level, blockState, pathPos, direction, spreadPath.getDirection())) continue;
                                    this.paths.add(tryPath);
                                }
                                break block49;
                            }
                            this.pathLookup.remove(pathPos);
                            this.paths.remove(i);
                            --i;
                            if (!level.f_46443_ || !this.showParticles) break block52;
                            rand = new Random();
                            if (Minecraft.m_91087_().f_91066_.f_92063_ && ClientSettingsConfig.getInstance().hearthDebug()) break block52;
                            v4 = rand.nextFloat();
                            v5 = this.spreading != false ? 0.016f : 0.032f;
                            if (v4 < v5) {
                                xr = rand.nextFloat();
                                yr = rand.nextFloat();
                                zr = rand.nextFloat();
                                xm = rand.nextFloat() / 20.0f - 0.025f;
                                zm = rand.nextFloat() / 20.0f - 0.025f;
                                level.m_6493_((ParticleOptions)ParticleTypesInit.HEARTH_AIR.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
                            }
                        }
                        if (level.f_46443_) continue;
                        for (p = 0; p < players.size(); ++p) {
                            player = (Player)players.get(p);
                            if (player == null || CSMath.getDistance((Vec3i)spreadPath.getPos(), (Vec3i)player.m_142538_()) > 1.0) continue;
                            players.remove(p);
                            --p;
                            effect = player.m_21124_(ModEffects.INSULATION);
                            if (effect != null && (effect.m_19557_() >= 60 || WorldHelper.canSeeSky(player.f_19853_, new BlockPos(player.m_20185_(), CSMath.ceil(player.m_20186_()), player.m_20189_()), 64))) continue;
                            this.insulatePlayer(player);
                            continue block7;
                        }
                        continue;
                    }
                    try {
                        if (!spreadPath.isFrozen()) {
                            spreadPath.freeze();
                            ++this.frozenPaths;
                        }
                        if (this.frozenPaths >= pathCount) {
                            this.spreading = false;
                        }
                        if (!level.f_46443_ || !this.showParticles) break block53;
                        rand = new Random();
                        if (Minecraft.m_91087_().f_91066_.f_92063_ && ClientSettingsConfig.getInstance().hearthDebug()) break block53;
                        v6 = rand.nextFloat();
                        v7 = this.spreading != false ? 0.016f : 0.032f;
                    }
                    catch (Throwable var24_77) {
                        if (level.f_46443_ && this.showParticles) {
                            rand = new Random();
                            if (!Minecraft.m_91087_().f_91066_.f_92063_ || !ClientSettingsConfig.getInstance().hearthDebug()) {
                                v8 = rand.nextFloat();
                                v9 = this.spreading != false ? 0.016f : 0.032f;
                                if (v8 < v9) {
                                    xr = rand.nextFloat();
                                    yr = rand.nextFloat();
                                    zr = rand.nextFloat();
                                    xm = rand.nextFloat() / 20.0f - 0.025f;
                                    zm = rand.nextFloat() / 20.0f - 0.025f;
                                    level.m_6493_((ParticleOptions)ParticleTypesInit.HEARTH_AIR.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
                                }
                            }
                        }
                        if (!level.f_46443_) {
                            for (p = 0; p < players.size(); ++p) {
                                player = (Player)players.get(p);
                                if (player == null || CSMath.getDistance((Vec3i)spreadPath.getPos(), (Vec3i)player.m_142538_()) > 1.0) continue;
                                players.remove(p);
                                --p;
                                effect = player.m_21124_(ModEffects.INSULATION);
                                if (effect != null && (effect.m_19557_() >= 60 || WorldHelper.canSeeSky(player.f_19853_, new BlockPos(player.m_20185_(), CSMath.ceil(player.m_20186_()), player.m_20189_()), 64))) continue;
                                this.insulatePlayer(player);
                                break;
                            }
                        }
                        throw var24_77;
                    }
                    if (v6 < v7) {
                        xr = rand.nextFloat();
                        yr = rand.nextFloat();
                        zr = rand.nextFloat();
                        xm = rand.nextFloat() / 20.0f - 0.025f;
                        zm = rand.nextFloat() / 20.0f - 0.025f;
                        level.m_6493_((ParticleOptions)ParticleTypesInit.HEARTH_AIR.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
                    }
                }
                if (level.f_46443_) continue;
                for (p = 0; p < players.size(); ++p) {
                    player = (Player)players.get(p);
                    if (player == null || CSMath.getDistance((Vec3i)spreadPath.getPos(), (Vec3i)player.m_142538_()) > 1.0) continue;
                    players.remove(p);
                    --p;
                    effect = player.m_21124_(ModEffects.INSULATION);
                    if (effect != null && (effect.m_19557_() >= 60 || WorldHelper.canSeeSky(player.f_19853_, new BlockPos(player.m_20185_(), CSMath.ceil(player.m_20186_()), player.m_20189_()), 64))) continue;
                    this.insulatePlayer(player);
                    continue block7;
                }
                continue;
            }
            if (this.ticksExisted % 80 == 0) {
                if (this.shouldUseColdFuel) {
                    this.setColdFuel(this.coldFuel - 1);
                }
                if (this.shouldUseHotFuel) {
                    this.setHotFuel(this.hotFuel - 1);
                }
                this.shouldUseColdFuel = false;
                this.shouldUseHotFuel = false;
            }
        }
        if (this.ticksExisted % 10 == 0 && !(fuelStack = (ItemStack)this.m_7086_().get(0)).m_41619_() && (itemFuel = HearthBlockEntity.getItemFuel(fuelStack)) != 0) {
            v10 = fuel = itemFuel > 0 ? this.hotFuel : this.coldFuel;
            if ((double)fuel < 1000.0 - (double)Math.abs(itemFuel) * 0.75) {
                if (fuelStack.hasContainerItem()) {
                    if (fuelStack.m_41613_() == 1) {
                        this.m_6836_(0, fuelStack.getContainerItem());
                        this.addFuel(itemFuel, this.hotFuel, this.coldFuel);
                    }
                } else {
                    consumeCount = Math.min((int)Math.floor((double)(1000 - fuel) / (double)Math.abs(itemFuel)), fuelStack.m_41613_());
                    fuelStack.m_41774_(consumeCount);
                    this.addFuel(itemFuel * consumeCount, this.hotFuel, this.coldFuel);
                }
            }
        }
        if (level.f_46443_) {
            rand = new Random();
            if (rand.nextDouble() < (double)this.coldFuel / 3000.0) {
                d0 = (double)pos.m_123341_() + 0.5;
                d1 = (double)pos.m_123342_() + 1.8;
                d2 = (double)pos.m_123343_() + 0.5;
                d3 = (rand.nextDouble() - 0.5) / 4.0;
                d4 = (rand.nextDouble() - 0.5) / 4.0;
                d5 = (rand.nextDouble() - 0.5) / 4.0;
                level.m_7106_((ParticleOptions)ParticleTypesInit.STEAM.get(), d0 + d3, d1 + d4, d2 + d5, 0.0, 0.04, 0.0);
            }
            if (rand.nextDouble() < (double)this.hotFuel / 3000.0) {
                d0 = (double)pos.m_123341_() + 0.5;
                d1 = (double)pos.m_123342_() + 1.8;
                d2 = (double)pos.m_123343_() + 0.5;
                d3 = (rand.nextDouble() - 0.5) / 2.0;
                d4 = (rand.nextDouble() - 0.5) / 2.0;
                d5 = (rand.nextDouble() - 0.5) / 2.0;
                particle = Math.random() < 0.5 ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_;
                level.m_7106_((ParticleOptions)particle, d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
            }
        }
    }

    boolean insulatePlayer(Player player) {
        if (!this.shouldUseHotFuel || !this.shouldUseColdFuel) {
            HearthTempModifier mod = TempHelper.getModifier(player, Temperature.Type.WORLD, HearthTempModifier.class);
            double temp = mod != null ? mod.getLastInput().get() : TempHelper.getTemperature(player, Temperature.Type.WORLD).get();
            this.shouldUseHotFuel = this.shouldUseHotFuel || this.hotFuel > 0 && temp < this.config.minTemp;
            boolean bl = this.shouldUseColdFuel = this.shouldUseColdFuel || this.coldFuel > 0 && temp > this.config.maxTemp;
        }
        if (this.shouldUseHotFuel || this.shouldUseColdFuel) {
            int effectLevel = Math.min(9, (int)((double)this.insulationLevel / (double)INSULATION_TIME * 9.0));
            player.m_7292_(new MobEffectInstance(ModEffects.INSULATION, 100, effectLevel, false, false, true));
            return true;
        }
        return false;
    }

    public static int getItemFuel(ItemStack item) {
        return ConfigSettings.HEARTH_FUEL.get().getOrDefault(item.m_41720_(), 0.0).intValue();
    }

    public int getHotFuel() {
        return this.hotFuel;
    }

    public int getColdFuel() {
        return this.coldFuel;
    }

    public void setHotFuel(int amount) {
        this.hotFuel = CSMath.clamp(amount, 0, 1000);
        this.updateFuelState();
        if (amount == 0 && this.hasHotFuel) {
            this.hasHotFuel = false;
            this.f_58857_.m_5594_(null, this.blockPos, ModSounds.HEARTH_FUEL, SoundSource.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
        } else {
            this.hasHotFuel = true;
        }
    }

    public void setColdFuel(int amount) {
        this.coldFuel = CSMath.clamp(amount, 0, 1000);
        this.updateFuelState();
        if (amount == 0 && this.hasColdFuel) {
            this.hasColdFuel = false;
            this.f_58857_.m_5594_(null, this.blockPos, ModSounds.HEARTH_FUEL, SoundSource.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
        } else {
            this.hasColdFuel = true;
        }
    }

    public void addFuel(int amount) {
        this.addFuel(amount, this.getHotFuel(), this.getColdFuel());
    }

    public void addFuel(int amount, int hotFuel, int coldFuel) {
        if (amount > 0) {
            this.setHotFuel(hotFuel + Math.abs(amount));
        } else if (amount < 0) {
            this.setColdFuel(coldFuel + Math.abs(amount));
        }
    }

    public void updateFuelState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            int waterLevel;
            int hotFuel = this.getHotFuel();
            int coldFuel = this.getColdFuel();
            BlockState state = this.f_58857_.m_8055_(this.blockPos);
            int n = coldFuel == 0 ? 0 : (waterLevel = coldFuel < 500 ? 1 : 2);
            int lavaLevel = hotFuel == 0 ? 0 : (hotFuel < 500 ? 1 : 2);
            BlockState desiredState = (BlockState)((BlockState)state.m_61124_((Property)HearthBottomBlock.WATER, (Comparable)Integer.valueOf(waterLevel))).m_61124_((Property)HearthBottomBlock.LAVA, (Comparable)Integer.valueOf(lavaLevel));
            if ((Integer)state.m_61143_((Property)HearthBottomBlock.WATER) != waterLevel || (Integer)state.m_61143_((Property)HearthBottomBlock.LAVA) != lavaLevel) {
                this.f_58857_.m_7731_(this.blockPos, desiredState, 3);
            }
            this.m_6596_();
            CompoundTag tag = new CompoundTag();
            this.m_183515_(tag);
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.blockPos)), (Object)new BlockDataUpdateMessage((BlockEntity)this));
        }
    }

    public int m_6643_() {
        return SLOT_COUNT;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new HearthContainer(id, playerInv, this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.setColdFuel(tag.m_128451_("coldFuel"));
        this.setHotFuel(tag.m_128451_("hotFuel"));
        this.insulationLevel = tag.m_128451_("insulationLevel");
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("coldFuel", this.getColdFuel());
        tag.m_128405_("hotFuel", this.getHotFuel());
        tag.m_128405_("insulationLevel", this.insulationLevel);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void replacePaths(Collection<SpreadPath> newPaths) {
        this.paths.clear();
        this.addPaths(newPaths);
        this.pathLookup.clear();
        this.pathLookup.addAll(newPaths.stream().map(SpreadPath::getPos).toList());
    }

    public void addPath(SpreadPath path) {
        this.paths.add(path);
    }

    public void addPaths(Collection<SpreadPath> newPaths) {
        this.paths.addAll(newPaths);
    }

    public void sendBlockUpdate(BlockPos pos) {
        this.notifyQueue.add(pos);
    }

    public void resetPaths() {
        this.forceRebuild = true;
    }

    public void m_7651_() {
        super.m_7651_();
        HearthPathManagement.HEARTH_POSITIONS.remove(this.blockPos);
    }

    public Set<BlockPos> getPaths() {
        return this.pathLookup;
    }

    private static /* synthetic */ LevelChunk lambda$tick$0(Level level, BlockPos pos) {
        return level.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }
}

