/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.blockentity;

import dev.momostudios.coldsweat.common.block.IceboxBlock;
import dev.momostudios.coldsweat.common.container.IceboxContainer;
import dev.momostudios.coldsweat.core.init.ParticleTypesInit;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.BlockDataUpdateMessage;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.registries.ModBlockEntities;
import dev.momostudios.coldsweat.util.registries.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class IceboxBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider {
    public static int[] WATERSKIN_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static int[] FUEL_SLOT = new int[]{0};
    public static int SLOTS = 10;
    public static int MAX_FUEL = 1000;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)SLOTS, (Object)ItemStack.f_41583_);
    List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();
    public int ticksExisted;
    int fuel;

    public IceboxBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ICEBOX, pos, state);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("fuel", this.getFuel());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setFuel(tag.m_128451_("fuel"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void sendUpdatePacket() {
        this.usingPlayers.removeIf(player -> {
            AbstractContainerMenu patt3152$temp = player.f_36096_;
            if (!(patt3152$temp instanceof IceboxContainer)) return true;
            IceboxContainer iceboxContainer = (IceboxContainer)patt3152$temp;
            if (iceboxContainer.te != this) return true;
            return false;
        });
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.NMLIST.with(() -> this.usingPlayers.stream().map(player -> player.f_8906_.f_9742_).toList()), (Object)new BlockDataUpdateMessage((BlockEntity)this));
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.cold_sweat.icebox");
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof IceboxBlockEntity) {
            IceboxBlockEntity iceboxTE = (IceboxBlockEntity)te;
            iceboxTE.tick(level, state, pos);
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        ++this.ticksExisted;
        if (!level.f_46443_) {
            ItemStack fuelStack;
            int itemFuel;
            if (this.getFuel() > 0) {
                if (!((Boolean)state.m_61143_((Property)IceboxBlock.FROSTED)).booleanValue()) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)IceboxBlock.FROSTED, (Comparable)Boolean.valueOf(true)), 3);
                }
                if (this.ticksExisted % 20 == 0) {
                    boolean hasItemStacks = false;
                    for (int i = 1; i < 10; ++i) {
                        ItemStack stack = this.m_8020_(i);
                        int itemTemp = stack.m_41784_().m_128451_("temperature");
                        if (stack.m_41720_() != ModItems.FILLED_WATERSKIN || itemTemp <= -50) continue;
                        hasItemStacks = true;
                        stack.m_41784_().m_128405_("temperature", itemTemp - 1);
                    }
                    if (hasItemStacks) {
                        this.setFuel(this.getFuel() - 1);
                    }
                }
            } else if (((Boolean)state.m_61143_((Property)IceboxBlock.FROSTED)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)IceboxBlock.FROSTED, (Comparable)Boolean.valueOf(false)), 3);
            }
            if (this.ticksExisted % 10 == 0 && (itemFuel = this.getItemFuel(fuelStack = this.m_8020_(0))) != 0 && this.getFuel() < MAX_FUEL - itemFuel / 2) {
                if (fuelStack.hasContainerItem() && fuelStack.m_41613_() == 1) {
                    this.m_6836_(0, fuelStack.getContainerItem());
                    this.setFuel(this.getFuel() + itemFuel);
                } else {
                    int consumeCount = Math.min((int)Math.floor((double)(MAX_FUEL - this.fuel) / (double)Math.abs(itemFuel)), fuelStack.m_41613_());
                    fuelStack.m_41774_(consumeCount);
                    this.setFuel(this.getFuel() + itemFuel * consumeCount);
                }
            }
        }
        if (((Boolean)state.m_61143_((Property)IceboxBlock.FROSTED)).booleanValue() && this.ticksExisted % 3 == 0 && Math.random() < 0.5) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            boolean side = new Random().nextBoolean();
            double d5 = side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
            double d6 = Math.random() * 0.3;
            double d7 = !side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
            level.m_7106_((ParticleOptions)ParticleTypesInit.MIST.get(), d0 + d5, d1 + d6, d2 + d7, d5 / 40.0, 0.0, d7 / 40.0);
        }
    }

    public int getItemFuel(ItemStack item) {
        return ConfigSettings.ICEBOX_FUEL.get().getOrDefault(item.m_41720_(), 0.0).intValue();
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int amount) {
        this.fuel = Math.min(amount, MAX_FUEL);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sendUpdatePacket();
        }
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        Player player = playerInv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.usingPlayers.add(serverPlayer);
        }
        return new IceboxContainer(id, playerInv, this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setFuel(tag.m_128451_("fuel"));
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("fuel", this.getFuel());
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public int m_6643_() {
        return SLOTS;
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void m_6836_(int slot, ItemStack itemstack) {
        this.items.set(slot, (Object)itemstack);
    }

    public ItemStack m_7407_(int slot, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)((ItemStack)this.items.get(slot)).m_41613_());
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }
}

