/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.capability;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.common.capability.ITemperatureCap;
import dev.momostudios.coldsweat.common.capability.ModCapabilities;
import dev.momostudios.coldsweat.common.capability.PlayerTempCap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerTempManager {
    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            final PlayerTempCap playerTempCap = new PlayerTempCap();
            final LazyOptional capOptional = LazyOptional.of(() -> playerTempCap);
            final Capability<ITemperatureCap> capability = ModCapabilities.PLAYER_TEMPERATURE;
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                    if (cap == capability) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return playerTempCap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    playerTempCap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "temperature"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
                if (event.side.isServer()) {
                    cap.tick(player);
                } else {
                    cap.tickDummy(player);
                }
                for (Temperature.Type type : PlayerTempCap.VALID_MODIFIER_TYPES) {
                    cap.getModifiers(type).removeIf(modifier -> {
                        int expireTime = modifier.getExpireTime();
                        return modifier.setTicksExisted(modifier.getTicksExisted() + 1) > expireTime && expireTime != -1;
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void returnFromEnd(PlayerEvent.Clone event) {
        if (!event.isWasDeath() && !event.getPlayer().f_19853_.f_46443_) {
            Player oldPlayer = event.getOriginal();
            oldPlayer.reviveCaps();
            event.getPlayer().getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> oldPlayer.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap::copy));
            oldPlayer.invalidateCaps();
        }
    }
}

