/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.container;

import dev.momostudios.coldsweat.core.init.MenuInit;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SewingContainer
extends AbstractContainerMenu {
    BlockPos pos;
    Inventory playerInventory;
    SewingInventory sewingInventory;

    public SewingContainer(int windowId, Inventory playerInv) {
        super((MenuType)MenuInit.SEWING_CONTAINER_TYPE.get(), windowId);
        this.pos = playerInv.f_35978_.m_142538_();
        this.playerInventory = playerInv;
        this.sewingInventory = new SewingInventory(this);
        this.m_38897_(new Slot(this.sewingInventory, 0, 43, 26){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean m_5857_(ItemStack stack) {
                if (!(stack.m_41720_() instanceof ArmorItem)) return false;
                if (SewingContainer.isInsulatingItem(stack)) return false;
                if (stack.m_41784_().m_128471_("insulated")) return false;
                return true;
            }

            public void m_142406_(Player player, ItemStack stack) {
                if (this.m_7993_().m_41619_()) {
                    SewingContainer.this.takeInput();
                }
            }

            public void m_6654_() {
                super.m_6654_();
                SewingContainer.this.testForRecipe();
            }
        });
        this.m_38897_(new Slot(this.sewingInventory, 1, 43, 53){

            public boolean m_5857_(ItemStack stack) {
                return SewingContainer.isInsulatingItem(stack);
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                SewingContainer.this.takeInput();
            }

            public void m_6654_() {
                super.m_6654_();
                SewingContainer.this.testForRecipe();
            }
        });
        this.m_38897_(new Slot(this.sewingInventory, 2, 121, 39){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                SewingContainer.this.takeOutput();
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + 9 * row + 9, 8 + col * 18, 166 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public SewingContainer(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(i, inventory);
        try {
            this.pos = BlockPos.m_122022_((long)friendlyByteBuf.readLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void takeInput() {
        this.sewingInventory.m_6836_(2, ItemStack.f_41583_);
    }

    private void takeOutput() {
        this.sewingInventory.m_8020_(0).m_41774_(1);
        this.m_150404_(0, this.sewingInventory.m_8020_(0));
        this.sewingInventory.m_8020_(1).m_41774_(1);
        this.m_150404_(1, this.sewingInventory.m_8020_(1));
        Player player = this.playerInventory.f_35978_;
        SoundEvent equipSound = this.m_142621_().m_41720_().m_142602_();
        if (equipSound != null) {
            player.f_19853_.m_5594_(null, player.m_142538_(), equipSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12100_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private ItemStack testForRecipe() {
        ItemStack slot0Item = this.sewingInventory.m_8020_(0);
        ItemStack slot1Item = this.sewingInventory.m_8020_(1);
        ItemStack result = ItemStack.f_41583_;
        if (slot0Item.m_41720_() instanceof ArmorItem && SewingContainer.isInsulatingItem(slot1Item) && (!(slot1Item.m_41720_() instanceof ArmorItem) || LivingEntity.m_147233_((ItemStack)slot0Item).equals((Object)LivingEntity.m_147233_((ItemStack)slot1Item)))) {
            ItemStack processed = slot0Item.m_41777_();
            processed.m_41784_().m_128379_("insulated", true);
            this.sewingInventory.m_6836_(2, processed);
            result = processed;
        }
        return result;
    }

    public SewingContainer(int windowId, Player playerInv, BlockPos pos) {
        this(windowId, playerInv.m_150109_());
        this.pos = pos;
    }

    public static boolean isInsulatingItem(ItemStack item) {
        return ConfigSettings.INSULATING_ITEMS.get().contains(item.m_41720_());
    }

    public void m_6877_(Player playerIn) {
        Inventory playerinventory = playerIn.m_150109_();
        playerIn.m_36176_(this.m_142621_(), false);
        this.m_142503_(ItemStack.f_41583_);
        for (int i = 0; i < this.sewingInventory.m_6643_(); ++i) {
            ItemEntity itementity;
            ItemStack itemStack = this.m_38853_(i).m_7993_();
            if (i == 2 || playerinventory.m_36054_(itemStack) || (itementity = playerinventory.f_35978_.m_36176_(itemStack, false)) == null) continue;
            itementity.m_32061_();
            itementity.m_32047_(playerinventory.f_35978_.m_142081_());
        }
    }

    public boolean m_6875_(Player playerIn) {
        if (this.pos != null) {
            return playerIn.m_20238_(Vec3.m_82512_((Vec3i)this.pos)) <= 64.0;
        }
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (CSMath.isInRange(index, 0.0, 2.0)) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (SewingContainer.isInsulatingItem(itemstack1)) {
                    if (!this.m_38903_(itemstack1, 1, 2, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (itemstack1.m_41720_() instanceof ArmorItem) {
                    if (!this.m_38903_(itemstack1, 0, 1, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (index == 2) {
                    if (!this.m_38903_(itemstack1, 3, 39, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (CSMath.isInRange(index, this.f_38839_.size() - 9, this.f_38839_.size())) {
                    if (!this.m_38903_(itemstack1, 3, 29, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (CSMath.isInRange(index, 3.0, this.f_38839_.size() - 9) && !this.m_38903_(itemstack1, this.f_38839_.size() - 9, this.f_38839_.size(), false)) {
                    slot.m_40234_(itemstack1, itemstack);
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            slot.m_40234_(itemstack1, itemstack);
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public static class SewingInventory
    implements Container {
        private final NonNullList<ItemStack> stackList = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        private final AbstractContainerMenu menu;

        public SewingInventory(AbstractContainerMenu menu) {
            this.menu = menu;
        }

        public int m_6643_() {
            return 3;
        }

        public boolean m_7983_() {
            return !this.stackList.stream().anyMatch(stack -> !stack.m_41619_());
        }

        @Nonnull
        public ItemStack m_8020_(int index) {
            return (ItemStack)this.stackList.get(index);
        }

        @Nonnull
        public ItemStack m_7407_(int index, int count) {
            ItemStack itemstack = ContainerHelper.m_18969_(this.stackList, (int)index, (int)count);
            if (!itemstack.m_41619_()) {
                this.menu.m_6199_((Container)this);
            }
            return itemstack;
        }

        @Nonnull
        public ItemStack m_8016_(int index) {
            return ContainerHelper.m_18966_(this.stackList, (int)index);
        }

        public void m_6836_(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.menu.m_6199_((Container)this);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            this.stackList.clear();
        }
    }
}

