/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.event;

import dev.momostudios.coldsweat.api.registry.TempModifierRegistry;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.BiomeTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.BlockTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.DepthTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.FoodTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.FreezingTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.HearthTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.MountTempModifier;
import dev.momostudios.coldsweat.api.temperature.modifier.WaterTempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.common.capability.ModCapabilities;
import dev.momostudios.coldsweat.config.EntitySettingsConfig;
import dev.momostudios.coldsweat.core.event.TaskScheduler;
import dev.momostudios.coldsweat.core.init.BlockInit;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModEffects;
import dev.momostudios.coldsweat.util.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AddTempModifiers {
    @SubscribeEvent
    public static void onPlayerCreated(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.f_19853_.f_46443_) {
                TaskScheduler.scheduleServer(() -> {
                    TempHelper.addModifier(player, new BiomeTempModifier().tickRate(10), Temperature.Type.WORLD, false);
                    if (ModList.get().isLoaded("sereneseasons")) {
                        TempHelper.addModifier(player, TempModifierRegistry.getEntryFor("sereneseasons:season").tickRate(20), Temperature.Type.WORLD, false);
                    }
                    TempHelper.addModifier(player, new DepthTempModifier().tickRate(10), Temperature.Type.WORLD, false);
                    TempHelper.addModifier(player, new BlockTempModifier().tickRate(5), Temperature.Type.WORLD, false);
                }, 10);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.f_19853_.f_46443_ && player.f_19797_ % 5 == 0 && player.m_20071_()) {
            TempHelper.addModifier(player, new WaterTempModifier(0.01f), Temperature.Type.WORLD, false);
        }
        if (!player.f_19853_.f_46443_ && player.f_19797_ % 5 == 0 && player.m_146888_() > 0) {
            TempHelper.replaceModifier(player, new FreezingTempModifier((float)player.m_146888_() / 13.5f).expires(5), Temperature.Type.BASE);
        }
    }

    @SubscribeEvent
    public static void onInsulationUpdate(PotionEvent event) {
        Entity entity;
        if (!event.getEntity().f_19853_.f_46443_ && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (event.getPotionEffect() != null && event.getPotionEffect().m_19544_() == ModEffects.INSULATION) {
                if (event instanceof PotionEvent.PotionAddedEvent) {
                    MobEffectInstance effect = event.getPotionEffect();
                    TempHelper.replaceModifier(player, new HearthTempModifier(effect.m_19564_() + 1).expires(effect.m_19557_()), Temperature.Type.WORLD);
                } else if (event instanceof PotionEvent.PotionRemoveEvent) {
                    TempHelper.removeModifiers(player, Temperature.Type.WORLD, 1, mod -> mod instanceof HearthTempModifier);
                }
            }
        }
    }

    @SubscribeEvent
    public static void removeInsulation(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && !player.f_19853_.f_46443_ && player.f_19797_ % 20 == 0 && player.m_21023_(ModEffects.INSULATION) && WorldHelper.canSeeSky(player.f_19853_, new BlockPos(player.m_20185_(), CSMath.ceil(player.m_20186_()), player.m_20189_()), 64)) {
            player.m_21195_(ModEffects.INSULATION);
        }
    }

    @SubscribeEvent
    public static void onSleep(SleepFinishedTimeEvent event) {
        if (!event.getWorld().m_5776_()) {
            event.getWorld().m_6907_().forEach(player -> {
                if (player.m_5803_()) {
                    player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
                        double temp = cap.getTemp(Temperature.Type.CORE);
                        cap.setTemp(Temperature.Type.CORE, temp / 4.0);
                        TempHelper.updateTemperature(player, cap, true);
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerRiding(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player).m_20202_() != null) {
            Minecart minecart;
            Entity mount = player.m_20202_();
            if (mount instanceof Minecart && (minecart = (Minecart)mount).m_38178_().m_60734_() == BlockInit.MINECART_INSULATION.get()) {
                TempHelper.addModifier(player, new MountTempModifier(1.0).expires(1), Temperature.Type.RATE, false);
            } else {
                EntitySettingsConfig.INSTANCE.insulatedEntities().stream().filter(entityID -> entityID.get(0).equals(mount.m_6095_().getRegistryName().toString())).findFirst().ifPresent(entityID -> {
                    float insulationAmount = ((Number)entityID.get(1)).floatValue();
                    TempHelper.addModifier(player, new MountTempModifier(insulationAmount).expires(1), Temperature.Type.RATE, false);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEatFood(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            float foodTemp;
            Player player = (Player)livingEntity;
            if (event.getItem().m_41614_() && !event.getEntityLiving().f_19853_.f_46443_ && (foodTemp = ConfigSettings.VALID_FOODS.get().getOrDefault(event.getItem().m_41720_(), 0.0).floatValue()) != 0.0f) {
                TempHelper.addModifier(player, new FoodTempModifier(foodTemp).expires(1), Temperature.Type.CORE, true);
            }
        }
    }
}

