/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.event;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PreventPlayerSleep {
    @SubscribeEvent
    public static void onTrySleep(PlayerSleepInBedEvent event) {
        if (event.getResultStatus() != null) {
            return;
        }
        Player player = event.getPlayer();
        double bodyTemp = TempHelper.getTemperature(player, Temperature.Type.BODY).get();
        double worldTemp = TempHelper.getTemperature(player, Temperature.Type.WORLD).get();
        double minTemp = ConfigSettings.getInstance().minTemp + TempHelper.getTemperature(player, Temperature.Type.MIN).get();
        double maxTemp = ConfigSettings.getInstance().maxTemp + TempHelper.getTemperature(player, Temperature.Type.MAX).get();
        if (!CSMath.isBetween(bodyTemp, -100.0, 100.0)) {
            player.m_5661_((Component)new TranslatableComponent("cold_sweat.message.sleep.body." + (bodyTemp > 99.0 ? "hot" : "cold")), true);
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        } else if (!CSMath.isInRange(worldTemp, minTemp, maxTemp)) {
            player.m_5661_((Component)new TranslatableComponent("cold_sweat.message.sleep.world." + (worldTemp > maxTemp ? "hot" : "cold")), true);
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }
}

