/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.common.item;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import dev.momostudios.coldsweat.api.util.TempHelper;
import dev.momostudios.coldsweat.client.gui.tooltip.SoulspringTooltip;
import dev.momostudios.coldsweat.core.itemgroup.ColdSweatGroup;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.ParticleBatchMessage;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.entity.NBTHelper;
import dev.momostudios.coldsweat.util.math.CSMath;
import dev.momostudios.coldsweat.util.registries.ModSounds;
import dev.momostudios.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class SoulspringLampItem
extends Item {
    public SoulspringLampItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(1).m_41486_());
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (!worldIn.f_46443_) {
                double max = ConfigSettings.getInstance().maxTemp;
                if (isSelected || player.m_21206_() == stack) {
                    SoulLampTempModifier lampMod = TempHelper.getModifier(player, Temperature.Type.WORLD, SoulLampTempModifier.class);
                    if (ConfigSettings.LAMP_DIMENSIONS.get().contains(worldIn.m_46472_().m_135782_().toString())) {
                        double temp;
                        double d = temp = lampMod != null ? lampMod.getLastInput().get() : TempHelper.getTemperature(player, Temperature.Type.WORLD).get();
                        if (d > max && this.getFuel(stack) > 0.0) {
                            if (player.f_19797_ % 5 == 0) {
                                if (!player.m_7500_() && !player.m_5833_()) {
                                    this.addFuel(stack, -0.01 * CSMath.clamp(temp - max, 1.0, 3.0));
                                }
                                AABB bb = new AABB(player.m_20185_() - 3.5, player.m_20186_() - 3.5, player.m_20189_() - 3.5, player.m_20185_() + 3.5, player.m_20186_() + 3.5, player.m_20189_() + 3.5);
                                for (Player entity : worldIn.m_45976_(Player.class, bb)) {
                                    SoulLampTempModifier modifier = TempHelper.getModifier(entity, Temperature.Type.WORLD, SoulLampTempModifier.class);
                                    if (modifier != null) {
                                        modifier.expires(modifier.getTicksExisted() + 5);
                                        continue;
                                    }
                                    TempHelper.replaceModifier(entity, new SoulLampTempModifier().expires(5).tickRate(5), Temperature.Type.WORLD);
                                }
                            }
                            if (stack.m_41784_().m_128451_("stateChangeTimer") <= 0 && !stack.m_41784_().m_128471_("isOn")) {
                                stack.m_41784_().m_128405_("stateChangeTimer", 10);
                                stack.m_41784_().m_128379_("isOn", true);
                                WorldHelper.playEntitySound(ModSounds.NETHER_LAMP_ON, (Entity)player, SoundSource.PLAYERS, 1.5f, (float)Math.random() / 5.0f + 0.9f);
                            }
                        }
                    }
                } else if (stack.m_41784_().m_128451_("stateChangeTimer") <= 0 && stack.m_41784_().m_128471_("isOn")) {
                    stack.m_41784_().m_128405_("stateChangeTimer", 10);
                    stack.m_41784_().m_128379_("isOn", false);
                    if (this.getFuel(stack) < 0.5) {
                        this.setFuel(stack, 0.0);
                    }
                    WorldHelper.playEntitySound(ModSounds.NETHER_LAMP_OFF, (Entity)player, SoundSource.PLAYERS, 1.5f, (float)Math.random() / 5.0f + 0.9f);
                }
                NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    private void setFuel(ItemStack stack, double fuel) {
        stack.m_41784_().m_128347_("fuel", fuel);
    }

    private void addFuel(ItemStack stack, double fuel) {
        this.setFuel(stack, Math.min(64.0, this.getFuel(stack) + fuel));
    }

    private double getFuel(ItemStack stack) {
        return stack.m_41784_().m_128459_("fuel");
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player && this.getFuel(stack) < 64.0 && !(target instanceof Player) && target.m_6336_() != MobType.f_21641_) {
            ParticleBatchMessage packet = new ParticleBatchMessage();
            this.addFuel(stack, 0.5);
            Random rand = new Random();
            int i = 0;
            while ((float)i < CSMath.clamp(target.m_20205_() * target.m_20205_() * target.m_20206_() * 3.0f, 5.0f, 50.0f)) {
                packet.addParticle((ParticleOptions)ParticleTypes.f_123746_, new ParticleBatchMessage.ParticlePlacement(target.m_20185_() + (double)(target.m_20205_() * rand.nextFloat()), target.m_20186_() + (double)(target.m_20206_() * rand.nextFloat()), target.m_20189_() + (double)(target.m_20205_() * rand.nextFloat()), rand.nextFloat() * 0.2f - 0.1f, rand.nextFloat() * 0.2f - 0.1f, rand.nextFloat() * 0.2f - 0.1f));
                ++i;
            }
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)packet);
            return true;
        }
        return super.m_7579_(stack, attacker, target);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos blockPos, Player player) {
        return !player.m_7500_();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> itemList) {
        if (this.m_41389_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128379_("isOn", true);
            stack.m_41784_().m_128347_("fuel", 64.0);
            itemList.add((Object)stack);
        }
    }

    public boolean m_142305_(ItemStack thisStack, ItemStack newStack, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (ConfigSettings.LAMP_FUEL_ITEMS.get().contains(newStack.m_41720_()) && this.getFuel(thisStack) < 64.0) {
            int stackCount = newStack.m_41613_();
            newStack.m_41774_(64 - (int)this.getFuel(thisStack));
            this.addFuel(thisStack, stackCount);
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new SoulspringTooltip(this.getFuel(stack)));
    }
}

