/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.config;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ColdSweatConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ColdSweatConfig configReference;
    public static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.IntValue difficulty;
    private static final ForgeConfigSpec.DoubleValue maxHabitable;
    private static final ForgeConfigSpec.DoubleValue minHabitable;
    private static final ForgeConfigSpec.DoubleValue rateMultiplier;
    private static final ForgeConfigSpec.BooleanValue fireResistanceEffect;
    private static final ForgeConfigSpec.BooleanValue iceResistanceEffect;
    private static final ForgeConfigSpec.BooleanValue damageScaling;
    private static final ForgeConfigSpec.BooleanValue requireThermometer;
    private static final ForgeConfigSpec.IntValue gracePeriodLength;
    private static final ForgeConfigSpec.BooleanValue gracePeriodEnabled;
    private static final ForgeConfigSpec.DoubleValue hearthEffect;
    private static final ForgeConfigSpec.BooleanValue coldSoulFire;
    private static final ForgeConfigSpec.BooleanValue showConfigButton;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> blockTemps;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/main.toml");
    }

    public static ColdSweatConfig getInstance() {
        return configReference;
    }

    public void writeValues(ConfigSettings cache) {
        this.setDifficulty(cache.difficulty);
        this.setMaxHabitable(cache.maxTemp);
        this.setMinHabitable(cache.minTemp);
        this.setRateMultiplier(cache.rate);
        this.setFireResistanceEnabled(cache.fireRes);
        this.setIceResistanceEnabled(cache.iceRes);
        this.setDamageScaling(cache.damageScaling);
        this.setRequireThermometer(cache.requireThermometer);
        this.setGracePeriodLength(cache.graceLength);
        this.setGracePeriodEnabled(cache.graceEnabled);
        this.save();
    }

    public boolean isButtonShowing() {
        return (Boolean)showConfigButton.get();
    }

    public int getDifficulty() {
        return (Integer)difficulty.get();
    }

    public boolean isFireResistanceEnabled() {
        return (Boolean)fireResistanceEffect.get();
    }

    public boolean isIceResistanceEnabled() {
        return (Boolean)iceResistanceEffect.get();
    }

    public boolean thermometerRequired() {
        return (Boolean)requireThermometer.get();
    }

    public boolean doDamageScaling() {
        return (Boolean)damageScaling.get();
    }

    public double getMinTempHabitable() {
        return (Double)minHabitable.get();
    }

    public double getMaxTempHabitable() {
        return (Double)maxHabitable.get();
    }

    public double getRateMultiplier() {
        return (Double)rateMultiplier.get();
    }

    public int getGracePeriodLength() {
        return (Integer)gracePeriodLength.get();
    }

    public boolean isGracePeriodEnabled() {
        return (Boolean)gracePeriodEnabled.get();
    }

    public boolean isSoulFireCold() {
        return (Boolean)coldSoulFire.get();
    }

    public List<? extends List<Object>> getBlockTemps() {
        return (List)blockTemps.get();
    }

    public double getHearthEffect() {
        return (Double)hearthEffect.get();
    }

    public void setDifficulty(int value) {
        difficulty.set((Object)value);
    }

    public void setMaxHabitable(double temp) {
        maxHabitable.set((Object)temp);
    }

    public void setMinHabitable(double temp) {
        minHabitable.set((Object)temp);
    }

    public void setRateMultiplier(double rate) {
        rateMultiplier.set((Object)rate);
    }

    public void setFireResistanceEnabled(boolean isEffective) {
        fireResistanceEffect.set((Object)isEffective);
    }

    public void setIceResistanceEnabled(boolean isEffective) {
        iceResistanceEffect.set((Object)isEffective);
    }

    public void setRequireThermometer(boolean required) {
        requireThermometer.set((Object)required);
    }

    public void setDamageScaling(boolean enabled) {
        damageScaling.set((Object)enabled);
    }

    public void setGracePeriodLength(int ticks) {
        gracePeriodLength.set((Object)ticks);
    }

    public void setGracePeriodEnabled(boolean enabled) {
        gracePeriodEnabled.set((Object)enabled);
    }

    public void save() {
        SPEC.save();
    }

    static {
        configReference = new ColdSweatConfig();
        BUILDER = new ForgeConfigSpec.Builder();
        showConfigButton = BUILDER.comment("Show the config menu button in the Options menu").define("Enable In-Game Config", true);
        difficulty = BUILDER.comment(new String[]{"Overrides all other config options for easy difficulty management", "This value is changed by the in-game config. It does nothing otherwise."}).defineInRange("Difficulty", 3, 1, 5);
        BUILDER.push("Item settings");
        fireResistanceEffect = BUILDER.comment("Fire Resistance blocks all hot temperatures").define("Fire Resistance Immunity", true);
        iceResistanceEffect = BUILDER.comment("Ice Resistance blocks all cold temperatures").define("Ice Resistance Immunity", true);
        requireThermometer = BUILDER.comment("Thermometer item is required to see world temperature").define("Require Thermometer", true);
        BUILDER.pop();
        BUILDER.push("Misc things that are affected by temperature");
        damageScaling = BUILDER.comment("Sets whether damage scales with difficulty").define("Damage Scaling", true);
        BUILDER.pop();
        BUILDER.push("Details about how the player is affected by temperature");
        minHabitable = BUILDER.comment("Minimum habitable temperature (default: " + CSMath.convertUnits(50.0, Temperature.Units.F, Temperature.Units.MC, true) + ")").defineInRange("Minimum Habitable Temperature", CSMath.convertUnits(50.0, Temperature.Units.F, Temperature.Units.MC, true), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        maxHabitable = BUILDER.comment("Maximum habitable temperature (default: " + CSMath.convertUnits(100.0, Temperature.Units.F, Temperature.Units.MC, true) + ")").defineInRange("Maximum Habitable Temperature", CSMath.convertUnits(100.0, Temperature.Units.F, Temperature.Units.MC, true), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        rateMultiplier = BUILDER.comment("Rate at which the player's body temperature changes (default: 1.0 (100%))").defineInRange("Rate Multiplier", 1.0, 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Grace Period Details");
        gracePeriodLength = BUILDER.comment("Grace period length in ticks (default: 6000)").defineInRange("Grace Period Length", 6000, 0, Integer.MAX_VALUE);
        gracePeriodEnabled = BUILDER.comment("Enables the grace period (default: true)").define("Grace Period Enabled", true);
        BUILDER.pop();
        BUILDER.push("Block Effects");
        blockTemps = BUILDER.comment(new String[]{"Allows for adding simple BlockTemps without the use of Java mods", "Format (All temperatures are in Minecraft units):", "[[\"block-ids\", <temperature>, <range (max 7)>, <*true/false: weaken over distance>, <*max effect>], [etc...], [etc...]]", "(* = optional) (1 \u00b0MC = 42 \u00b0F/ 23.33 \u00b0C)", "", "Arguments:", "block-ids: multiple IDs can be used by separating them with commas (i.e: \"minecraft:torch,minecraft:wall_torch\")", "temperature: the temperature of the block, in Minecraft units", "weaken over distance: the block is less effective as distance increases", "max effect: the max temperature change this block can cause to a player (even with multiple blocks)"}).defineList("BlockTemps", Arrays.asList(Arrays.asList(Blocks.f_50084_.getRegistryName().toString(), -0.2, 7, true, 0.8), Arrays.asList(Blocks.f_50083_.getRegistryName().toString(), 0.2, 7, true, 0.8), Arrays.asList(Blocks.f_50450_.getRegistryName().toString(), 0.15, 3, true, 0.6), Arrays.asList(Blocks.f_50126_.getRegistryName().toString(), -0.2, 1.5, true, 0.8), Arrays.asList(Blocks.f_50354_.getRegistryName().toString(), -0.3, 1.5, true, 1.2), Arrays.asList(Blocks.f_50568_.getRegistryName().toString(), -0.4, 1.5, true, 1.6)), it -> true);
        BUILDER.pop();
        BUILDER.push("Hearth Strength");
        hearthEffect = BUILDER.comment("How strong the hearth is (default: 0.5)").defineInRange("Hearth Strength", 0.5, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Cold Soul Fire");
        coldSoulFire = BUILDER.comment(new String[]{"Converts damage dealt by Soul Fire to cold damage (default: true)", "Does not affect the block's temperature"}).define("Cold Soul Fire", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

