/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.config;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class EntitySettingsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> insulatedEntities;
    public static final EntitySettingsConfig INSTANCE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/entity_settings.toml");
    }

    public List<? extends List<Object>> insulatedEntities() {
        return (List)insulatedEntities.get();
    }

    public void setInsulatedEntities(List<? extends List<Object>> list) {
        insulatedEntities.set(list);
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new EntitySettingsConfig();
        BUILDER.push("Mount Settings");
        insulatedEntities = BUILDER.comment(new String[]{"List of entities that will insulate the player when riding them", "Format: [\"entity-id\", insulation-amount]", "(1 is complete insulation, 0 is no insulation)"}).defineList("Insulated Entities", Arrays.asList(new List[0]), it -> it instanceof List && ((List)it).size() == 2 && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

