/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.event;

import dev.momostudios.coldsweat.ColdSweat;
import java.util.LinkedHashMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TaskScheduler {
    static volatile LinkedHashMap<Runnable, Integer> SERVER_SCHEDULE = new LinkedHashMap();
    static volatile LinkedHashMap<Runnable, Integer> CLIENT_SCHEDULE = new LinkedHashMap();

    @SubscribeEvent
    public static synchronized void runScheduledTasks(TickEvent event) {
        if ((event instanceof TickEvent.ServerTickEvent || event instanceof TickEvent.ClientTickEvent) && event.phase == TickEvent.Phase.START) {
            LinkedHashMap<Runnable, Integer> schedule;
            LinkedHashMap<Runnable, Integer> linkedHashMap = schedule = event.side.isClient() ? CLIENT_SCHEDULE : SERVER_SCHEDULE;
            if (schedule.isEmpty()) {
                return;
            }
            schedule.entrySet().removeIf(task -> {
                if ((Integer)task.getValue() <= 0) {
                    try {
                        ((Runnable)task.getKey()).run();
                        return true;
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Error while running scheduled task", (Throwable)e);
                        e.printStackTrace();
                    }
                } else {
                    task.setValue((Integer)task.getValue() - 1);
                }
                return false;
            });
        }
    }

    public static void scheduleServer(Runnable task, int delay) {
        SERVER_SCHEDULE.put(task, delay);
    }

    public static void scheduleClient(Runnable task, int delay) {
        CLIENT_SCHEDULE.put(task, delay);
    }
}

