/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class BlockDataUpdateMessage {
    BlockPos blockPos;
    BlockEntity blockEntity;
    CompoundTag tag;

    public BlockDataUpdateMessage(BlockEntity blockEntity) {
        this.blockPos = blockEntity.m_58899_();
        this.blockEntity = blockEntity;
    }

    public BlockDataUpdateMessage(BlockPos blockPos, CompoundTag tag) {
        this.blockPos = blockPos;
        this.tag = tag;
    }

    public static void encode(BlockDataUpdateMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.blockPos);
        buffer.m_130079_(message.blockEntity.m_187482_());
    }

    public static BlockDataUpdateMessage decode(FriendlyByteBuf buffer) {
        return new BlockDataUpdateMessage(buffer.m_130135_(), buffer.m_130260_());
    }

    public static void handle(BlockDataUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                BlockEntity be;
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null && (be = level.m_7702_(message.blockPos)) != null) {
                    be.m_142466_(message.tag);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

