/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.network.message;

import dev.momostudios.coldsweat.config.ColdSweatConfig;
import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.ClientConfigRecieveMessage;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ClientConfigAskMessage {
    boolean openMenu;

    public ClientConfigAskMessage(boolean openMenu) {
        this.openMenu = openMenu;
    }

    public static void encode(ClientConfigAskMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.openMenu);
    }

    public static ClientConfigAskMessage decode(FriendlyByteBuf buffer) {
        return new ClientConfigAskMessage(buffer.readBoolean());
    }

    public static void handle(ClientConfigAskMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ConfigSettings cache = new ConfigSettings();
            cache.readValues(ColdSweatConfig.getInstance());
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new ClientConfigRecieveMessage(cache, message.openMenu));
        });
        context.setPacketHandled(true);
    }
}

