/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.network.message;

import com.mojang.datafixers.util.Pair;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ParticleBatchMessage {
    Set<Pair<ParticleOptions, ParticlePlacement>> particles = new HashSet<Pair<ParticleOptions, ParticlePlacement>>();

    public void addParticle(ParticleOptions particle, ParticlePlacement placement) {
        this.particles.add((Pair<ParticleOptions, ParticlePlacement>)Pair.of((Object)particle, (Object)placement));
    }

    public static void encode(ParticleBatchMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.particles.size());
        for (Pair<ParticleOptions, ParticlePlacement> entry : message.particles) {
            String particleID = ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)((ParticleOptions)entry.getFirst()).m_6012_()).toString();
            buffer.writeInt(particleID.length());
            buffer.writeCharSequence((CharSequence)particleID, StandardCharsets.UTF_8);
            ((ParticleOptions)entry.getFirst()).m_7711_(buffer);
            buffer.m_130079_(((ParticlePlacement)entry.getSecond()).toNBT());
        }
    }

    public static ParticleBatchMessage decode(FriendlyByteBuf buffer) {
        ParticleBatchMessage message = new ParticleBatchMessage();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int particleIDLength = buffer.readInt();
            ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(buffer.readCharSequence(particleIDLength, StandardCharsets.UTF_8).toString()));
            ParticleOptions particle = type.m_123743_().m_6507_(type, buffer);
            ParticlePlacement placement = ParticlePlacement.fromNBT(buffer.m_130260_());
            message.addParticle(particle, placement);
        }
        return message;
    }

    public static void handle(ParticleBatchMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                for (Pair<ParticleOptions, ParticlePlacement> entry : message.particles) {
                    ParticleOptions particle = (ParticleOptions)entry.getFirst();
                    ParticlePlacement placement = (ParticlePlacement)entry.getSecond();
                    Minecraft.m_91087_().f_91073_.m_7106_(particle, placement.x, placement.y, placement.z, placement.vx, placement.vy, placement.vz);
                }
            });
        }
        context.setPacketHandled(true);
    }

    public static class ParticlePlacement {
        ParticleOptions particle;
        double x;
        double y;
        double z;
        double vx;
        double vy;
        double vz;

        public ParticlePlacement(double x, double y, double z, double vx, double vy, double vz) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("x", this.x);
            tag.m_128347_("y", this.y);
            tag.m_128347_("z", this.z);
            tag.m_128347_("vx", this.vx);
            tag.m_128347_("vy", this.vy);
            tag.m_128347_("vz", this.vz);
            return tag;
        }

        public static ParticlePlacement fromNBT(CompoundTag tag) {
            return new ParticlePlacement(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"), tag.m_128459_("vx"), tag.m_128459_("vy"), tag.m_128459_("vz"));
        }
    }
}

