/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.core.network.message;

import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.client.gui.Overlays;
import dev.momostudios.coldsweat.common.capability.ModCapabilities;
import dev.momostudios.coldsweat.common.capability.PlayerTempCap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PlayerTempSyncMessage {
    CompoundTag temps;
    boolean instant;

    public PlayerTempSyncMessage(CompoundTag temps, boolean instant) {
        this.temps = temps;
        this.instant = instant;
    }

    public static void encode(PlayerTempSyncMessage message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.temps);
        buffer.writeBoolean(message.instant);
    }

    public static PlayerTempSyncMessage decode(FriendlyByteBuf buffer) {
        return new PlayerTempSyncMessage(buffer.m_130260_(), buffer.readBoolean());
    }

    public static void handle(PlayerTempSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.getCapability(ModCapabilities.PLAYER_TEMPERATURE).ifPresent(cap -> {
                        if (cap instanceof PlayerTempCap) {
                            PlayerTempCap playerTempCap = (PlayerTempCap)cap;
                            playerTempCap.deserializeTemps(message.temps);
                            if (message.instant) {
                                Overlays.setBodyTemp(cap.getTemp(Temperature.Type.BODY));
                            }
                        }
                    });
                }
            });
        }
        context.setPacketHandled(true);
    }
}

