/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.util.config;

import com.mojang.datafixers.util.Pair;
import dev.momostudios.coldsweat.ColdSweat;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.util.config.ConfigSettings;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

public class ConfigHelper {
    public static CompoundTag writeConfigSettingsToNBT(ConfigSettings config) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("difficulty", config.difficulty);
        tag.m_128347_("minTemp", config.minTemp);
        tag.m_128347_("maxTemp", config.maxTemp);
        tag.m_128347_("rate", config.rate);
        tag.m_128379_("fireResistance", config.fireRes);
        tag.m_128379_("iceResistance", config.iceRes);
        tag.m_128379_("damageScaling", config.damageScaling);
        tag.m_128379_("requireThermometer", config.requireThermometer);
        tag.m_128405_("graceLength", config.graceLength);
        tag.m_128379_("graceEnabled", config.graceEnabled);
        return tag;
    }

    public static ConfigSettings readConfigSettingsFromNBT(CompoundTag tag) {
        ConfigSettings config = new ConfigSettings();
        if (tag == null) {
            ColdSweat.LOGGER.error("Failed to read config settings!");
            return config;
        }
        config.difficulty = tag.m_128451_("difficulty");
        config.minTemp = tag.m_128459_("minTemp");
        config.maxTemp = tag.m_128459_("maxTemp");
        config.rate = tag.m_128459_("rate");
        config.fireRes = tag.m_128471_("fireResistance");
        config.iceRes = tag.m_128471_("iceResistance");
        config.damageScaling = tag.m_128471_("damageScaling");
        config.requireThermometer = tag.m_128471_("requireThermometer");
        config.graceLength = tag.m_128451_("graceLength");
        config.graceEnabled = tag.m_128471_("graceEnabled");
        return config;
    }

    public static List<Block> getBlocks(String ... ids) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String id : ids) {
            if (id.startsWith("#")) {
                String tagID = id.replace("#", "");
                Optional<ITag> optionalTag = ForgeRegistries.BLOCKS.tags().stream().filter(tag -> tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                optionalTag.ifPresent(blockITag -> blocks.addAll(blockITag.stream().toList()));
                continue;
            }
            blocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id)));
        }
        return blocks;
    }

    public static Map<Block, Number> getBlocksWithValues(List<? extends List<?>> source) {
        HashMap<Block, Number> map = new HashMap<Block, Number>();
        for (List<?> entry : source) {
            String blockID = (String)entry.get(0);
            if (blockID.startsWith("#")) {
                String tagID = blockID.replace("#", "");
                Optional<ITag> optionalTag = ForgeRegistries.BLOCKS.tags().stream().filter(tag -> tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                optionalTag.ifPresent(blockITag -> {
                    for (Block block : ((ITag)optionalTag.get()).stream().toList()) {
                        map.put(block, (Number)entry.get(1));
                    }
                });
                continue;
            }
            Block newBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockID));
            if (newBlock == null) continue;
            map.put(newBlock, (Number)entry.get(1));
        }
        return map;
    }

    public static List<Item> getItems(String ... ids) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String id : ids) {
            if (id.startsWith("#")) {
                String tagID = id.replace("#", "");
                Optional<ITag> optionalTag = ForgeRegistries.ITEMS.tags().stream().filter(tag -> tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                optionalTag.ifPresent(itemITag -> items.addAll(itemITag.stream().toList()));
                continue;
            }
            items.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id)));
        }
        return items;
    }

    public static Map<Item, Double> getItemsWithValues(List<? extends List<?>> source) {
        HashMap<Item, Double> map = new HashMap<Item, Double>();
        for (List<?> entry : source) {
            String itemID = (String)entry.get(0);
            if (itemID.startsWith("#")) {
                String tagID = itemID.replace("#", "");
                Optional<ITag> optionalTag = ForgeRegistries.ITEMS.tags().stream().filter(tag -> tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                optionalTag.ifPresent(itemITag -> {
                    for (Item item : ((ITag)optionalTag.get()).stream().toList()) {
                        map.put(item, ((Number)entry.get(1)).doubleValue());
                    }
                });
                continue;
            }
            Item newItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemID));
            if (newItem == null) continue;
            map.put(newItem, ((Number)entry.get(1)).doubleValue());
        }
        return map;
    }

    public static Map<ResourceLocation, Pair<Double, Double>> getBiomesWithValues(List<? extends List<?>> source, boolean absolute) {
        HashMap<ResourceLocation, Pair<Double, Double>> map = new HashMap<ResourceLocation, Pair<Double, Double>>();
        for (List<?> entry : source) {
            try {
                String biomeID = (String)entry.get(0);
                List<Biome> biomes = biomeID.startsWith("#") ? ForgeRegistries.BIOMES.tags().stream().filter(tag -> tag.getKey().f_203868_().toString().equals(biomeID.replace("#", ""))).findFirst().orElseThrow(Exception::new).stream().toList() : Collections.singletonList((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeID)));
                for (Biome biome : biomes) {
                    double max;
                    double min;
                    if (entry.size() > 2) {
                        Temperature.Units units = entry.size() == 4 ? Temperature.Units.valueOf(((String)entry.get(3)).toUpperCase()) : Temperature.Units.MC;
                        min = CSMath.convertUnits(((Number)entry.get(1)).doubleValue(), units, Temperature.Units.MC, absolute);
                        max = CSMath.convertUnits(((Number)entry.get(2)).doubleValue(), units, Temperature.Units.MC, absolute);
                    } else {
                        double mid = ((Number)entry.get(1)).doubleValue();
                        double variance = 1.0f / Math.max(1.0f, 2.0f + biome.m_47548_() * 2.0f);
                        min = mid - variance;
                        max = mid + variance;
                    }
                    map.put(biome.getRegistryName(), (Pair<Double, Double>)Pair.of((Object)min, (Object)max));
                }
            }
            catch (Exception exception) {
            }
        }
        return map;
    }
}

