/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.util.config;

import com.mojang.datafixers.util.Pair;
import dev.momostudios.coldsweat.config.ColdSweatConfig;
import dev.momostudios.coldsweat.config.ItemSettingsConfig;
import dev.momostudios.coldsweat.config.WorldSettingsConfig;
import dev.momostudios.coldsweat.util.config.ConfigHelper;
import dev.momostudios.coldsweat.util.config.ConfigValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;

public class ConfigSettings {
    public static ConfigValue<Map<ResourceLocation, Pair<Double, Double>>> BIOME_TEMPS = ConfigValue.of(() -> ConfigHelper.getBiomesWithValues(WorldSettingsConfig.getInstance().biomeTemperatures(), true));
    public static ConfigValue<Map<ResourceLocation, Pair<Double, Double>>> BIOME_OFFSETS = ConfigValue.of(() -> ConfigHelper.getBiomesWithValues(WorldSettingsConfig.getInstance().biomeOffsets(), false));
    public static ConfigValue<Map<ResourceLocation, Double>> DIMENSION_TEMPS = ConfigValue.of(() -> {
        HashMap<ResourceLocation, Double> map = new HashMap<ResourceLocation, Double>();
        for (List<?> entry : WorldSettingsConfig.getInstance().dimensionTemperatures()) {
            map.put(new ResourceLocation((String)entry.get(0)), ((Number)entry.get(1)).doubleValue());
        }
        return map;
    });
    public static ConfigValue<Map<ResourceLocation, Double>> DIMENSION_OFFSETS = ConfigValue.of(() -> {
        HashMap<ResourceLocation, Double> map = new HashMap<ResourceLocation, Double>();
        for (List<?> entry : WorldSettingsConfig.getInstance().dimensionOffsets()) {
            map.put(new ResourceLocation((String)entry.get(0)), ((Number)entry.get(1)).doubleValue());
        }
        return map;
    });
    public static ConfigValue<Double[]> SUMMER_TEMPS;
    public static ConfigValue<Double[]> AUTUMN_TEMPS;
    public static ConfigValue<Double[]> WINTER_TEMPS;
    public static ConfigValue<Double[]> SPRING_TEMPS;
    public static ConfigValue<List<Item>> INSULATING_ITEMS;
    public static ConfigValue<Map<Item, Double>> INSULATING_ARMORS;
    public static ConfigValue<Map<Item, Double>> VALID_FOODS;
    public static ConfigValue<Integer> WATERSKIN_STRENGTH;
    public static ConfigValue<List<Item>> LAMP_FUEL_ITEMS;
    public static ConfigValue<List<String>> LAMP_DIMENSIONS;
    public static ConfigValue<Map<Item, Double>> BOILER_FUEL;
    public static ConfigValue<Map<Item, Double>> ICEBOX_FUEL;
    public static ConfigValue<Map<Item, Double>> HEARTH_FUEL;
    public int difficulty;
    public double maxTemp;
    public double minTemp;
    public double rate;
    public boolean fireRes;
    public boolean iceRes;
    public boolean damageScaling;
    public boolean requireThermometer;
    public int graceLength;
    public boolean graceEnabled;
    private static ConfigSettings INSTANCE;

    public ConfigSettings() {
    }

    public static ConfigSettings getInstance() {
        return INSTANCE;
    }

    public static void setInstance(ConfigSettings instance) {
        INSTANCE = instance;
    }

    public ConfigSettings(ColdSweatConfig config) {
        this.readValues(config);
    }

    public void readValues(ColdSweatConfig config) {
        this.difficulty = config.getDifficulty();
        this.maxTemp = config.getMaxTempHabitable();
        this.minTemp = config.getMinTempHabitable();
        this.rate = config.getRateMultiplier();
        this.fireRes = config.isFireResistanceEnabled();
        this.iceRes = config.isIceResistanceEnabled();
        this.damageScaling = config.doDamageScaling();
        this.requireThermometer = config.thermometerRequired();
        this.graceLength = config.getGracePeriodLength();
        this.graceEnabled = config.isGracePeriodEnabled();
    }

    static {
        BOILER_FUEL = ConfigValue.of(() -> ConfigHelper.getItemsWithValues(ItemSettingsConfig.getInstance().boilerItems()));
        HEARTH_FUEL = ConfigValue.of(() -> ConfigHelper.getItemsWithValues(ItemSettingsConfig.getInstance().hearthItems()));
        ICEBOX_FUEL = ConfigValue.of(() -> ConfigHelper.getItemsWithValues(ItemSettingsConfig.getInstance().iceboxItems()));
        INSULATING_ITEMS = ConfigValue.of(() -> {
            ArrayList<Item> list = new ArrayList<Item>();
            for (String string : ItemSettingsConfig.getInstance().insulatingItems()) {
                list.addAll(ConfigHelper.getItems(string));
            }
            return list;
        });
        INSULATING_ARMORS = ConfigValue.of(() -> ConfigHelper.getItemsWithValues(ItemSettingsConfig.getInstance().insulatingArmor()));
        VALID_FOODS = ConfigValue.of(() -> ConfigHelper.getItemsWithValues(ItemSettingsConfig.getInstance().temperatureFoods()));
        WATERSKIN_STRENGTH = ConfigValue.of(() -> ItemSettingsConfig.getInstance().waterskinStrength());
        LAMP_FUEL_ITEMS = ConfigValue.of(() -> {
            ArrayList<Item> list = new ArrayList<Item>();
            for (String string : ItemSettingsConfig.getInstance().soulLampItems()) {
                list.addAll(ConfigHelper.getItems(string));
            }
            return list;
        });
        LAMP_DIMENSIONS = ConfigValue.of(() -> new ArrayList<String>(ItemSettingsConfig.getInstance().soulLampDimensions()));
        if (ModList.get().isLoaded("sereneseasons")) {
            SUMMER_TEMPS = ConfigValue.of(() -> WorldSettingsConfig.getInstance().summerTemps());
            AUTUMN_TEMPS = ConfigValue.of(() -> WorldSettingsConfig.getInstance().autumnTemps());
            WINTER_TEMPS = ConfigValue.of(() -> WorldSettingsConfig.getInstance().winterTemps());
            SPRING_TEMPS = ConfigValue.of(() -> WorldSettingsConfig.getInstance().springTemps());
        }
        INSTANCE = new ConfigSettings();
    }
}

