/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.util.math;

import com.mojang.math.Vector3d;
import dev.momostudios.coldsweat.api.temperature.Temperature;
import dev.momostudios.coldsweat.util.math.InterruptableStreamer;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CSMath {
    public static double convertUnits(double value, Temperature.Units from, Temperature.Units to, boolean absolute) {
        return switch (from) {
            default -> throw new IncompatibleClassChangeError();
            case Temperature.Units.C -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield value;
                    }
                    case F: {
                        yield value * 1.8 + 32.0;
                    }
                    case MC: 
                }
                yield value / 23.333333333;
            }
            case Temperature.Units.F -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield (value - 32.0) / 1.8;
                    }
                    case F: {
                        yield value;
                    }
                    case MC: 
                }
                yield (value - (absolute ? 32.0 : 0.0)) / 42.0;
            }
            case Temperature.Units.MC -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield value * 23.333333333;
                    }
                    case F: {
                        yield value * 42.0 + (absolute ? 32.0 : 0.0);
                    }
                    case MC: 
                }
                yield value;
            }
        };
    }

    public static float toRadians(float input) {
        return input * ((float)Math.PI / 180);
    }

    public static float toDegrees(float input) {
        return input * 57.29578f;
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double ceil(double value) {
        return value + (1.0 - value % 1.0);
    }

    public static double floor(double value) {
        return value - value % 1.0;
    }

    public static boolean isInRange(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(double value, double min, double max) {
        return value > min && value < max;
    }

    public static double blend(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax) {
        if (factor <= rangeMin) {
            return blendFrom;
        }
        if (factor >= rangeMax) {
            return blendTo;
        }
        return 1.0 / (rangeMax - rangeMin) * (factor - rangeMin) * (blendTo - blendFrom) + blendFrom;
    }

    public static float blend(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        if (factor <= rangeMin) {
            return blendFrom;
        }
        if (factor >= rangeMax) {
            return blendTo;
        }
        return 1.0f / (rangeMax - rangeMin) * (factor - rangeMin) * (blendTo - blendFrom) + blendFrom;
    }

    public static double getDistance(Entity entity, Vec3 pos) {
        return CSMath.getDistance(entity, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static double getDistanceSqr(double x1, double y1, double z1, double x2, double y2, double z2) {
        double xDistance = Math.abs(x1 - x2);
        double yDistance = Math.abs(y1 - y2);
        double zDistance = Math.abs(z1 - z2);
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(CSMath.getDistanceSqr(x1, y1, z1, x2, y2, z2));
    }

    public static double getDistance(Vec3 pos1, Vec3 pos2) {
        return CSMath.getDistance(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_);
    }

    public static double getDistance(Entity entity, double x, double y, double z) {
        return CSMath.getDistance(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), x, y, z);
    }

    public static double getDistance(Vec3i pos1, Vec3i pos2) {
        return Math.sqrt(pos1.m_123331_(pos2));
    }

    public static double average(Number ... values) {
        double sum = 0.0;
        for (Number value : values) {
            sum += value.doubleValue();
        }
        return sum / (double)values.length;
    }

    public static double weightedAverage(double val1, double val2, double weight1, double weight2) {
        return (val1 * weight1 + val2 * weight2) / (weight1 + weight2);
    }

    public static double weightedAverage(Map<? extends Number, ? extends Number> values) {
        double sum = 0.0;
        double weightSum = 0.0;
        for (Map.Entry<? extends Number, ? extends Number> entry : values.entrySet()) {
            double weight = entry.getValue().doubleValue();
            sum += entry.getKey().doubleValue() * weight;
            weightSum += weight;
        }
        return sum / weightSum;
    }

    public static Vec3 vectorToVec(Vector3d vec) {
        return new Vec3(vec.f_86214_, vec.f_86215_, vec.f_86216_);
    }

    public static Direction getDirectionFromVector(double x, double y, double z) {
        Direction direction = Direction.NORTH;
        double f = 1.4E-45f;
        for (Direction direction1 : Direction.values()) {
            double f1 = x * (double)direction1.m_122429_() + y * (double)direction1.m_122430_() + z * (double)direction1.m_122431_();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public static Direction getDirectionFromVector(Vec3 vec3) {
        return CSMath.getDirectionFromVector(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public static <T> void breakableForEach(Collection<T> collection, BiConsumer<T, InterruptableStreamer<T>> consumer) {
        new InterruptableStreamer<T>(collection).run(consumer);
    }

    public static void tryCatch(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getSign(double value) {
        if (value == 0.0) {
            return 0;
        }
        return (int)(value / Math.abs(value));
    }

    public static int getSignForRange(double value, double min, double max) {
        return value > max ? 1 : (value < min ? -1 : 0);
    }

    public static double crop(double value, int sigFigs) {
        return (double)((int)(value * Math.pow(10.0, sigFigs))) / Math.pow(10.0, sigFigs);
    }

    public static int blendColors(int color1, int color2, float ratio) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return r << 16 | g << 8 | b;
    }

    public static double getMostExtreme(double value1, double value2) {
        return Math.abs(value1) > Math.abs(value2) ? value1 : value2;
    }

    public static double getLeastExtreme(double value1, double value2) {
        return Math.abs(value1) < Math.abs(value2) ? value1 : value2;
    }

    public static Vec3 getMiddle(BlockPos pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static VoxelShape rotateShape(Direction to, VoxelShape shape) {
        VoxelShape[] shapeHolder = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            shapeHolder[0] = shapeHolder[1];
            shapeHolder[1] = Shapes.m_83040_();
        }
        return shapeHolder[0];
    }

    public static VoxelShape flattenShape(Direction.Axis axis, VoxelShape shape) {
        VoxelShape[] shapeHolder = new VoxelShape[]{shape, Shapes.m_83040_()};
        switch (axis) {
            case X: {
                shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_83048_((double)0.0, (double)minY, (double)minZ, (double)1.0, (double)maxY, (double)maxZ));
                });
                break;
            }
            case Y: {
                shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)0.0, (double)minZ, (double)maxX, (double)1.0, (double)maxZ));
                });
                break;
            }
            case Z: {
                shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minY, (double)0.0, (double)maxX, (double)maxY, (double)1.0));
                });
            }
        }
        return shapeHolder[1];
    }
}

