/*
 * Decompiled with CFR 0.152.
 */
package dev.momostudios.coldsweat.util.world;

import dev.momostudios.coldsweat.core.network.ColdSweatPacketHandler;
import dev.momostudios.coldsweat.core.network.message.PlaySoundMessage;
import dev.momostudios.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class WorldHelper {
    public static int getGroundLevel(BlockPos pos, Level level) {
        int mcHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        if (pos.m_123342_() >= mcHeight) {
            return mcHeight;
        }
        LevelChunk chunk = level.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunk == null) {
            return mcHeight;
        }
        for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
            BlockPos pos2 = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            LevelChunkSection subchunk = WorldHelper.getChunkSection((ChunkAccess)chunk, pos2.m_123342_());
            if (subchunk == null) {
                return mcHeight;
            }
            if (subchunk.m_188008_()) {
                y += 16 - y % 16;
                continue;
            }
            BlockState state = subchunk.m_62982_(pos2.m_123341_() & 0xF, pos2.m_123342_() & 0xF, pos2.m_123343_() & 0xF);
            if (!state.m_60795_() || state.m_60734_() == Blocks.f_50627_) continue;
            return y;
        }
        return mcHeight;
    }

    public static List<BlockPos> getNearbyPositions(BlockPos pos, int samples, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int sampleRoot = (int)Math.sqrt(samples);
        int radius = sampleRoot * interval / 2;
        for (int x = 0; x < sampleRoot; ++x) {
            for (int z = 0; z < sampleRoot; ++z) {
                posList.add(pos.m_142082_(x * interval - radius, 0, z * interval - radius));
            }
        }
        return posList;
    }

    public static boolean canSeeSky(LevelChunk chunk, Level level, BlockPos pos, int maxDistance) {
        for (int i = 0; i < Math.min(maxDistance, level.m_141928_() - pos.m_123342_()); ++i) {
            BlockPos pos2 = pos.m_6630_(i);
            LevelChunkSection subchunk = WorldHelper.getChunkSection((ChunkAccess)chunk, pos2.m_123342_());
            if (subchunk.m_188008_()) {
                i += 16 - i % 16;
                continue;
            }
            BlockState state = subchunk.m_62982_(pos2.m_123341_() & 0xF, pos2.m_123342_() & 0xF, pos2.m_123343_() & 0xF);
            if (!WorldHelper.isSpreadBlocked(level, state, pos2, Direction.UP, Direction.UP)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSeeSky(Level level, BlockPos pos, int maxDistance) {
        LevelChunk chunk = (LevelChunk)level.m_7726_().m_7587_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
        return chunk == null || WorldHelper.canSeeSky(chunk, level, pos, maxDistance);
    }

    public static boolean isSpreadBlocked(Level level, BlockState state, BlockPos pos, Direction toDir, Direction fromDir) {
        if (state.m_60795_()) {
            return false;
        }
        VoxelShape shape = state.m_60734_().m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        return fromDir == toDir ? WorldHelper.isFullSide(CSMath.flattenShape(toDir.m_122434_(), shape), toDir) : WorldHelper.isFullSide(shape.m_83263_(toDir), toDir) || WorldHelper.isFullSide(shape.m_83263_(fromDir.m_122424_()), fromDir.m_122424_());
    }

    public static boolean isFullSide(VoxelShape shape, Direction dir) {
        if (shape.m_83281_()) {
            return false;
        }
        if (shape.equals(Shapes.m_83144_())) {
            return true;
        }
        double[] area = new double[1];
        switch (dir.m_122434_()) {
            case X: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + (y2 - y1) * (z2 - z1);
                });
                break;
            }
            case Y: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + (x2 - x1) * (z2 - z1);
                });
                break;
            }
            case Z: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + (x2 - x1) * (y2 - y1);
                });
            }
        }
        return area[0] >= 1.0;
    }

    public static BlockState getBlockState(ChunkAccess chunk, BlockPos blockpos) {
        int x = blockpos.m_123341_();
        int y = blockpos.m_123342_();
        int z = blockpos.m_123343_();
        try {
            return (BlockState)WorldHelper.getChunkSection(chunk, y).m_63019_().m_63087_(x & 0xF, y & 0xF, z & 0xF);
        }
        catch (Exception e) {
            return chunk.m_8055_(blockpos);
        }
    }

    public static LevelChunkSection getChunkSection(ChunkAccess chunk, int y) {
        LevelChunkSection[] sections = chunk.m_7103_();
        return sections[Math.min(sections.length - 1, (y >> 4) - chunk.m_151560_())];
    }

    public static void playEntitySound(SoundEvent sound, Entity entity, SoundSource source, float volume, float pitch) {
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new PlaySoundMessage(sound.getRegistryName().toString(), source, volume, pitch, entity.m_142049_()));
    }

    public static void forBlocksInRay(Vec3 from, Vec3 to, Level level, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        if (!from.equals((Object)to)) {
            Vec3 ray = to.m_82546_(from);
            Vec3 normalRay = ray.m_82541_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            ChunkAccess workingChunk = level.m_7726_().m_7587_((int)from.f_82479_ >> 4, (int)from.f_82481_ >> 4, ChunkStatus.f_62326_, false);
            int i = 0;
            while ((double)i < ray.m_82553_()) {
                Vec3 vec = from.m_82549_(normalRay.m_82490_((double)i));
                if (!new BlockPos(vec).equals((Object)pos)) {
                    pos.m_122169_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                    if (workingChunk == null || !workingChunk.m_7697_().equals((Object)new ChunkPos((BlockPos)pos))) {
                        workingChunk = level.m_7726_().m_7587_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
                    }
                    if (workingChunk != null) {
                        BlockState state = WorldHelper.getChunkSection(workingChunk, pos.m_123342_()).m_62982_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF);
                        if (!state.m_60795_() && --maxHits <= 0) break;
                        rayTracer.accept(state, (BlockPos)pos);
                    }
                }
                ++i;
            }
        }
    }

    public static Entity raycastEntity(Vec3 from, Vec3 to, Level level, Predicate<Entity> filter) {
        if (!from.equals((Object)to)) {
            Vec3 ray = to.m_82546_(from);
            Vec3 normalRay = ray.m_82541_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i < ray.m_82553_()) {
                Vec3 vec = from.m_82549_(normalRay.m_82490_((double)i));
                if (!new BlockPos(vec).equals((Object)pos)) {
                    pos.m_122169_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                    List entities = level.m_6443_(Entity.class, new AABB((BlockPos)pos), filter);
                    if (!entities.isEmpty()) {
                        return (Entity)entities.get(0);
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

