/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.quark.content.management.module.ItemSharingModule;
import vazkii.quark.content.tools.module.ColorRunesModule;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Inject(method={"render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at={@At(value="HEAD")})
    private void setColorRuneTargetStack(ItemStack itemStackIn, ItemTransforms.TransformType transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn, CallbackInfo callbackInfo) {
        ColorRunesModule.setTargetStack(itemStackIn);
    }

    @Redirect(method={"getArmorFoilBuffer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;armorGlint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getArmorGlint() {
        return ColorRunesModule.getArmorGlint();
    }

    @Redirect(method={"getArmorFoilBuffer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;armorEntityGlint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getArmorEntityGlint() {
        return ColorRunesModule.getArmorEntityGlint();
    }

    @Redirect(method={"getFoilBuffer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;glintTranslucent()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getGlintTranslucent() {
        return ColorRunesModule.getGlintTranslucent();
    }

    @Redirect(method={"getFoilBuffer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;glint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getGlint() {
        return ColorRunesModule.getGlint();
    }

    @Redirect(method={"getFoilBuffer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;entityGlint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getEntityGlint() {
        return ColorRunesModule.getEntityGlint();
    }

    @Redirect(method={"getFoilBufferDirect"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;glintDirect()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getGlintDirect() {
        return ColorRunesModule.getGlintDirect();
    }

    @Redirect(method={"getFoilBufferDirect"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;entityGlintDirect()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getEntityGlintDirect() {
        return ColorRunesModule.getEntityGlintDirect();
    }

    @Accessor(value="itemColors")
    public abstract ItemColors getItemColors();

    @Inject(method={"renderQuadList"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderQuads(PoseStack ms, VertexConsumer builder, List<BakedQuad> quads, ItemStack stack, int lightmap, int overlay, CallbackInfo ci) {
        if (ItemSharingModule.alphaValue != 1.0f) {
            boolean flag = !stack.m_41619_();
            PoseStack.Pose entry = ms.m_85850_();
            for (BakedQuad bakedquad : quads) {
                int i = flag && bakedquad.m_111304_() ? this.getItemColors().m_92676_(stack, bakedquad.m_111305_()) : -1;
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                builder.putBulkData(entry, bakedquad, r, g, b, ItemSharingModule.alphaValue, lightmap, overlay, true);
            }
            ci.cancel();
        }
    }
}

