/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client;

import com.cursedcauldron.wildbackport.client.particle.SculkChargeParticle;
import com.cursedcauldron.wildbackport.client.particle.SculkChargePopParticle;
import com.cursedcauldron.wildbackport.client.particle.SculkSoulParticle;
import com.cursedcauldron.wildbackport.client.particle.ShriekParticle;
import com.cursedcauldron.wildbackport.client.particle.SonicBoomParticle;
import com.cursedcauldron.wildbackport.client.registry.WBParticleTypes;
import com.cursedcauldron.wildbackport.client.render.AllayRenderer;
import com.cursedcauldron.wildbackport.client.render.ChestBoatRenderer;
import com.cursedcauldron.wildbackport.client.render.FrogRenderer;
import com.cursedcauldron.wildbackport.client.render.TadpoleRenderer;
import com.cursedcauldron.wildbackport.client.render.WardenRenderer;
import com.cursedcauldron.wildbackport.client.render.model.AllayModel;
import com.cursedcauldron.wildbackport.client.render.model.ChestBoatModel;
import com.cursedcauldron.wildbackport.client.render.model.FrogModel;
import com.cursedcauldron.wildbackport.client.render.model.TadpoleModel;
import com.cursedcauldron.wildbackport.client.render.model.WardenModel;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.core.api.ColorRegistry;
import com.cursedcauldron.wildbackport.core.api.ParticleRegistry;
import com.cursedcauldron.wildbackport.core.api.RenderRegistry;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSetup {
    public static void onClient() {
        ColorRegistry.register((state, getter, pos, tint) -> getter == null || pos == null ? FoliageColor.m_46113_() : BiomeColors.m_108804_((BlockAndTintGetter)getter, (BlockPos)pos), WBBlocks.MANGROVE_LEAVES);
        ColorRegistry.register((stack, tint) -> 9619016, WBBlocks.MANGROVE_LEAVES);
        RenderRegistry.setLayerDefinition(AllayRenderer.MODEL_LAYER, AllayModel::createBodyLayer);
        RenderRegistry.setEntityRender(WBEntityTypes.ALLAY, AllayRenderer::new);
        RenderRegistry.setLayerDefinition(WardenRenderer.MODEL_LAYER, WardenModel::createBodyLayer);
        RenderRegistry.setEntityRender(WBEntityTypes.WARDEN, WardenRenderer::new);
        RenderRegistry.setLayerDefinition(FrogRenderer.MODEL_LAYER, FrogModel::createBodyLayer);
        RenderRegistry.setEntityRender(WBEntityTypes.FROG, FrogRenderer::new);
        RenderRegistry.setLayerDefinition(TadpoleRenderer.MODEL_LAYER, TadpoleModel::createBodyLayer);
        RenderRegistry.setEntityRender(WBEntityTypes.TADPOLE, TadpoleRenderer::new);
        for (Boat.Type type : Boat.Type.values()) {
            RenderRegistry.setLayerDefinition(ChestBoatModel.createChestBoat(type), () -> ChestBoatModel.createBodyModel(true));
        }
        RenderRegistry.setEntityRender(WBEntityTypes.MANGROVE_BOAT, context -> new ChestBoatRenderer(context, false));
        RenderRegistry.setEntityRender(WBEntityTypes.CHEST_BOAT, context -> new ChestBoatRenderer(context, true));
        ParticleRegistry.create(WBParticleTypes.SCULK_SOUL, SculkSoulParticle.Provider::new);
        ParticleRegistry.create(WBParticleTypes.SCULK_CHARGE, SculkChargeParticle.Provider::new);
        ParticleRegistry.create(WBParticleTypes.SCULK_CHARGE_POP, SculkChargePopParticle.Provider::new);
        ParticleRegistry.create(WBParticleTypes.SHRIEK, ShriekParticle.Provider::new);
        ParticleRegistry.create(WBParticleTypes.SONIC_BOOM, SonicBoomParticle.Provider::new);
    }

    public static void onPostClient() {
        RenderRegistry.setBlockRenderType(RenderType.m_110463_(), WBBlocks.SCULK_VEIN.get(), WBBlocks.SCULK_SHRIEKER.get(), WBBlocks.FROGSPAWN.get(), WBBlocks.MANGROVE_ROOTS.get(), WBBlocks.MANGROVE_TRAPDOOR.get(), WBBlocks.MANGROVE_PROPAGULE.get(), WBBlocks.POTTED_MANGROVE_PROPAGULE.get());
    }
}

