/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.animation.api;

import com.cursedcauldron.wildbackport.client.animation.api.Animated;
import com.cursedcauldron.wildbackport.client.animation.api.Keyframe;
import com.cursedcauldron.wildbackport.common.utils.MathUtils;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record Transformation(Target target, Keyframe[] keyframes) {

    public static interface Target {
        public void apply(ModelPart var1, Vector3f var2);
    }

    public static interface Interpolation {
        public Vector3f apply(Vector3f var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }

    public static class Targets {
        public static final Target TRANSLATE = Animated::translate;
        public static final Target ROTATE = Animated::rotate;
        public static final Target SCALE = Animated::scaleY;
    }

    public static class Interpolations {
        public static final Interpolation LINEAL = (cache, delta, keyframes, start, end, speed) -> {
            Vector3f frameStart = keyframes[start].target();
            Vector3f frameEnd = keyframes[end].target();
            cache.m_122245_(Mth.m_14179_((float)delta, (float)frameStart.m_122239_(), (float)frameEnd.m_122239_()) * speed, Mth.m_14179_((float)delta, (float)frameStart.m_122260_(), (float)frameEnd.m_122260_()) * speed, Mth.m_14179_((float)delta, (float)frameStart.m_122269_(), (float)frameEnd.m_122269_()) * speed);
            return cache;
        };
        public static final Interpolation CATMULL = (cache, delta, keyframes, start, end, speed) -> {
            Vector3f frameStartPoint = keyframes[Math.max(0, start - 1)].target();
            Vector3f frameStart = keyframes[start].target();
            Vector3f frameEnd = keyframes[end].target();
            Vector3f frameEndPoint = keyframes[Math.min(keyframes.length - 1, end + 1)].target();
            cache.m_122245_(MathUtils.catmullrom(delta, frameStartPoint.m_122239_(), frameStart.m_122239_(), frameEnd.m_122239_(), frameEndPoint.m_122239_()) * speed, MathUtils.catmullrom(delta, frameStartPoint.m_122260_(), frameStart.m_122260_(), frameEnd.m_122260_(), frameEndPoint.m_122260_()) * speed, MathUtils.catmullrom(delta, frameStartPoint.m_122269_(), frameStart.m_122269_(), frameEnd.m_122269_(), frameEndPoint.m_122269_()) * speed);
            return cache;
        };
    }
}

