/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render.model;

import com.cursedcauldron.wildbackport.common.entities.MangroveBoat;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;

public class ChestBoatModel
extends ListModel<MangroveBoat> {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public ChestBoatModel(ModelPart root, boolean chest) {
        this.leftPaddle = root.m_171324_("left_paddle");
        this.rightPaddle = root.m_171324_("right_paddle");
        this.waterPatch = root.m_171324_("water_patch");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{root.m_171324_("bottom"), root.m_171324_("back"), root.m_171324_("front"), root.m_171324_("right"), root.m_171324_("left"), this.leftPaddle, this.rightPaddle});
        if (chest) {
            builder.add((Object)root.m_171324_("chest_bottom"));
            builder.add((Object)root.m_171324_("chest_lid"));
            builder.add((Object)root.m_171324_("chest_lock"));
        }
        this.parts = builder.build();
    }

    public static LayerDefinition createBodyModel(boolean chested) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        part.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        part.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-15.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        part.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f), PartPose.m_171423_((float)15.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        part.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        part.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)9.0f));
        if (chested) {
            part.m_171599_("chest_bottom", CubeListBuilder.m_171558_().m_171514_(0, 76).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 8.0f, 12.0f), PartPose.m_171423_((float)-2.0f, (float)-5.0f, (float)-6.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
            part.m_171599_("chest_lid", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 4.0f, 12.0f), PartPose.m_171423_((float)-2.0f, (float)-9.0f, (float)-6.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
            part.m_171599_("chest_lock", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        }
        part.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        part.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(62, 20).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        part.m_171599_("water_patch", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)(chested ? 128 : 64));
    }

    public void setupAnim(MangroveBoat boat, float angle, float distance, float animationProgress, float yaw, float pitch) {
        ChestBoatModel.animatePaddle(boat, 0, this.leftPaddle, angle);
        ChestBoatModel.animatePaddle(boat, 1, this.rightPaddle, angle);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    public ModelPart waterPatch() {
        return this.waterPatch;
    }

    private static void animatePaddle(MangroveBoat boat, int sigma, ModelPart part, float angle) {
        float time = boat.m_38315_(sigma, angle);
        part.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-time)) + 1.0f) / 2.0f));
        part.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-time + 1.0f)) + 1.0f) / 2.0f));
        if (sigma == 1) {
            part.f_104204_ = (float)Math.PI - part.f_104204_;
        }
    }

    public static ModelLayerLocation createChestBoat(Boat.Type type) {
        return new ModelLayerLocation(new ResourceLocation("wildbackport", "chest_boat/" + type.m_38429_()), "main");
    }
}

