/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.cursedcauldron.wildbackport.core.mixin.access.PointedDripstoneBlockAccessor;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public record DrippingFluid(BlockPos pos, Fluid fluid, BlockState sourceState) {
    public static void fillCauldron(BlockState state, ServerLevel world, BlockPos blockPos, CallbackInfo ci) {
        Optional<DrippingFluid> fluidAbove = DrippingFluid.getFluidAboveStalactite((Level)world, blockPos, state);
        if (fluidAbove.isPresent()) {
            Fluid fluid = fluidAbove.get().fluid;
            if (fluidAbove.get().sourceState().m_204336_(WBBlockTags.MUD) && fluid == Fluids.f_76193_) {
                world.m_46597_(fluidAbove.get().pos, Blocks.f_50129_.m_49966_());
                world.m_46796_(1504, blockPos, 0);
                ci.cancel();
            }
        }
    }

    public static Optional<DrippingFluid> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !PointedDripstoneBlockAccessor.callIsStalactite(state) ? Optional.empty() : PointedDripstoneBlockAccessor.callFindRootBlock(level, pos, state, 11).map(blockPos -> {
            BlockPos position = blockPos.m_7494_();
            BlockState sourceState = level.m_8055_(position);
            Fluid fluid = sourceState.m_204336_(WBBlockTags.MUD) && !level.m_6042_().m_63951_() ? Fluids.f_76193_ : level.m_6425_(position).m_76152_();
            return new DrippingFluid(position, fluid, sourceState);
        });
    }
}

