/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.frog;

import com.cursedcauldron.wildbackport.common.entities.Frog;
import com.cursedcauldron.wildbackport.common.entities.access.api.Poses;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.Path;

public class FrogEat
extends Behavior<Frog> {
    private int eatTick;
    private int moveToTargetTick;
    private final SoundEvent tongueSound;
    private final SoundEvent eatSound;
    private Phase phase = Phase.DONE;

    public FrogEat(SoundEvent tongueSound, SoundEvent eatSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 100);
        this.tongueSound = tongueSound;
        this.eatSound = eatSound;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Frog frog) {
        LivingEntity target = (LivingEntity)frog.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        boolean flag = this.canMoveToTarget(frog, target);
        if (!flag) {
            frog.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            this.cantReachTarget(frog, target);
        }
        return flag && frog.m_20089_() != Poses.CROAKING.get() && Frog.isValidFrogFood(target);
    }

    protected boolean canStillUse(ServerLevel level, Frog frog, long time) {
        return frog.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.phase != Phase.DONE;
    }

    protected void start(ServerLevel level, Frog frog, long time) {
        LivingEntity entity = (LivingEntity)frog.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        BehaviorUtils.m_22595_((LivingEntity)frog, (LivingEntity)entity);
        frog.setFrogTarget((Entity)entity);
        frog.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(entity.m_20182_(), 2.0f, 0));
        this.moveToTargetTick = 10;
        this.phase = Phase.MOVE_TO_TARGET;
    }

    protected void stop(ServerLevel level, Frog frog, long time) {
        frog.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        frog.clearFrogTarget();
        frog.m_20124_(Pose.STANDING);
    }

    private void eat(ServerLevel level, Frog frog) {
        Entity entity;
        level.m_6269_(null, (Entity)frog, this.eatSound, SoundSource.NEUTRAL, 2.0f, 1.0f);
        Optional<Entity> target = frog.getFrogTarget();
        if (target.isPresent() && (entity = target.get()).m_6084_()) {
            frog.m_7327_(entity);
            if (!entity.m_6084_()) {
                entity.m_19983_(FrogEat.dropStack(frog, entity));
                entity.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    private static ItemStack dropStack(Frog frog, Entity entity) {
        if (entity instanceof MagmaCube) {
            return new ItemStack((ItemLike)(switch (frog.getVariant()) {
                default -> throw new IncompatibleClassChangeError();
                case Frog.Variant.TEMPERATE -> WBBlocks.OCHRE_FROGLIGHT.get().m_5456_();
                case Frog.Variant.WARM -> WBBlocks.PEARLESCENT_FROGLIGHT.get().m_5456_();
                case Frog.Variant.COLD -> WBBlocks.VERDANT_FROGLIGHT.get().m_5456_();
            }));
        }
        return new ItemStack((ItemLike)Items.f_42518_);
    }

    protected void tick(ServerLevel level, Frog frog, long time) {
        LivingEntity target = (LivingEntity)frog.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        frog.setFrogTarget((Entity)target);
        switch (this.phase) {
            case MOVE_TO_TARGET: {
                if (target.m_20270_((Entity)frog) < 1.75f) {
                    level.m_6269_(null, (Entity)frog, this.tongueSound, SoundSource.NEUTRAL, 2.0f, 1.0f);
                    frog.m_20124_(Poses.USING_TONGUE.get());
                    target.m_20256_(target.m_20182_().m_82505_(frog.m_20182_()).m_82541_().m_82490_(0.75));
                    this.eatTick = 0;
                    this.phase = Phase.CATCH_ANIMATION;
                    break;
                }
                if (this.moveToTargetTick <= 0) {
                    frog.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(target.m_20182_(), 2.0f, 0));
                    this.moveToTargetTick = 10;
                    break;
                }
                --this.moveToTargetTick;
                break;
            }
            case CATCH_ANIMATION: {
                if (this.eatTick++ < 6) break;
                this.phase = Phase.EAT_ANIMATION;
                this.eat(level, frog);
                break;
            }
            case EAT_ANIMATION: {
                if (this.eatTick >= 10) {
                    this.phase = Phase.DONE;
                    break;
                }
                ++this.eatTick;
            }
        }
    }

    private boolean canMoveToTarget(Frog frog, LivingEntity entity) {
        Path path = frog.m_21573_().m_6570_((Entity)entity, 0);
        return path != null && path.m_77407_() < 1.75f;
    }

    private void cantReachTarget(Frog frog, LivingEntity entity) {
        boolean notTargeting;
        List targets = frog.m_6274_().m_21952_(WBMemoryModules.UNREACHABLE_TONGUE_TARGETS.get()).orElseGet(ArrayList::new);
        boolean bl = notTargeting = !targets.contains(entity.m_142081_());
        if (targets.size() == 5 && notTargeting) {
            targets.remove(0);
        }
        if (notTargeting) {
            targets.add(entity.m_142081_());
        }
        frog.m_6274_().m_21882_(WBMemoryModules.UNREACHABLE_TONGUE_TARGETS.get(), (Object)targets, 100L);
    }

    static enum Phase {
        MOVE_TO_TARGET,
        CATCH_ANIMATION,
        EAT_ANIMATION,
        DONE;

    }
}

