/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WardenSpawnHelper {
    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> type, MobSpawnType spawnType, ServerLevel level, BlockPos pos, int tries, int xzRange, int yRange) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 0; i < tries; ++i) {
            Mob mob;
            int x = Mth.m_144928_((Random)level.f_46441_, (int)(-xzRange), (int)xzRange);
            int z = Mth.m_144928_((Random)level.f_46441_, (int)(-xzRange), (int)xzRange);
            mutable.m_122154_((Vec3i)pos, x, yRange, z);
            if (!level.m_6857_().m_61937_((BlockPos)mutable) || !WardenSpawnHelper.moveToPossibleSpawnPosition(level, yRange, mutable) || (mob = (Mob)type.m_20655_(level, null, null, null, (BlockPos)mutable, spawnType, false, false)) == null) continue;
            if (mob.m_5545_((LevelAccessor)level, spawnType) && mob.m_6914_((LevelReader)level)) {
                level.m_47205_((Entity)mob);
                return Optional.of(mob);
            }
            mob.m_146870_();
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(ServerLevel level, int yRange, BlockPos.MutableBlockPos pos) {
        BlockPos.MutableBlockPos toPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlockState toState = level.m_8055_((BlockPos)toPos);
        for (int i = yRange; i >= -yRange; --i) {
            pos.m_122173_(Direction.DOWN);
            toPos.m_122159_((Vec3i)pos, Direction.UP);
            BlockState state = level.m_8055_((BlockPos)pos);
            if (WardenSpawnHelper.canSpawnOn(level, (BlockPos)pos, state, (BlockPos)toPos, toState)) {
                pos.m_122173_(Direction.UP);
                return true;
            }
            toState = state;
        }
        return false;
    }

    public static boolean canSpawnOn(ServerLevel level, BlockPos pos, BlockState state, BlockPos toPos, BlockState toState) {
        return toState.m_60812_((BlockGetter)level, toPos).m_83281_() && Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)level, pos), (Direction)Direction.UP);
    }
}

