/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.features;

import com.cursedcauldron.wildbackport.common.worldgen.features.GrassDiskConfiguration;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class GrassDiskFeature
extends Feature<GrassDiskConfiguration> {
    public GrassDiskFeature(Codec<GrassDiskConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GrassDiskConfiguration> context) {
        GrassDiskConfiguration config = (GrassDiskConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        Random random = context.m_159776_();
        boolean place = false;
        int y = pos.m_123342_();
        int topY = y + config.halfHeight();
        int bottomY = y - config.halfHeight() - 1;
        int radius = config.radius().m_142270_(random);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos position : BlockPos.m_121940_((BlockPos)pos.m_142082_(-radius, 0, -radius), (BlockPos)pos.m_142082_(radius, 0, radius))) {
            int z;
            int x = position.m_123341_() - position.m_123341_();
            if (x * x + (z = position.m_123343_() - position.m_123343_()) * z > radius * radius) continue;
            place |= this.placeBlock(config, level, random, topY, bottomY, mutable.m_122190_((Vec3i)position));
        }
        return place;
    }

    protected boolean placeBlock(GrassDiskConfiguration config, WorldGenLevel level, Random random, int topY, int bottomY, BlockPos.MutableBlockPos pos) {
        boolean place = false;
        for (int y = topY; y > bottomY; --y) {
            pos.m_142448_(y);
            if (!config.target().test((Object)level, (Object)pos)) continue;
            BlockState state = config.stateProvider().getBlockState(level, random, (BlockPos)pos);
            level.m_7731_((BlockPos)pos, state, 2);
            this.m_159739_(level, (BlockPos)pos);
            place = true;
        }
        return place;
    }
}

