/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.piglinexpansion.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.piglinexpansion.world.features.PiglinAbandonedRefugeFeature;
import net.mcreator.piglinexpansion.world.features.PiglinFortressFeature;
import net.mcreator.piglinexpansion.world.features.PiglinShipFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class PiglinExpansionModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"piglin_expansion");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> PIGLIN_FORTRESS = PiglinExpansionModFeatures.register("piglin_fortress", PiglinFortressFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, PiglinFortressFeature.GENERATE_BIOMES, PiglinFortressFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PIGLIN_ABANDONED_REFUGE = PiglinExpansionModFeatures.register("piglin_abandoned_refuge", PiglinAbandonedRefugeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, PiglinAbandonedRefugeFeature.GENERATE_BIOMES, PiglinAbandonedRefugeFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PIGLIN_SHIP = PiglinExpansionModFeatures.register("piglin_ship", PiglinShipFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, PiglinShipFeature.GENERATE_BIOMES, PiglinShipFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

