/*
 * Decompiled with CFR 0.152.
 */
package com.github.channelingmc.visuality;

import com.github.channelingmc.visuality.config.ClientConfig;
import com.github.channelingmc.visuality.config.block.BlockAmbientParticles;
import com.github.channelingmc.visuality.config.block.BlockStepParticles;
import com.github.channelingmc.visuality.config.entity.EntityArmorParticles;
import com.github.channelingmc.visuality.config.entity.EntityHitParticles;
import com.github.channelingmc.visuality.particle.ChargeParticle;
import com.github.channelingmc.visuality.particle.FeatherParticle;
import com.github.channelingmc.visuality.particle.SlimeParticle;
import com.github.channelingmc.visuality.particle.SolidFallingParticle;
import com.github.channelingmc.visuality.particle.SoulParticle;
import com.github.channelingmc.visuality.particle.SparkleParticle;
import com.github.channelingmc.visuality.particle.WaterCircleParticle;
import com.github.channelingmc.visuality.particle.type.VisualityParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="visuality")
public class Visuality {
    public static final String ID = "visuality";
    public static EntityHitParticles ENTITY_HIT_PARTICLES;
    public static EntityArmorParticles ENTITY_ARMOR_PARTICLES;
    public static BlockAmbientParticles BLOCK_AMBIENT_PARTICLES;
    public static BlockStepParticles BLOCK_STEP_PARTICLES;

    public Visuality() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        VisualityParticleTypes.PARTICLE_TYPES.register(modBus);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "visuality/client.toml");
            modBus.addListener(this::registerClientResourceListener);
            modBus.addListener(this::registerParticleProviders);
        }
    }

    public void registerClientResourceListener(RegisterClientReloadListenersEvent event) {
        ENTITY_HIT_PARTICLES = new EntityHitParticles();
        event.registerReloadListener((PreparableReloadListener)ENTITY_HIT_PARTICLES);
        ENTITY_ARMOR_PARTICLES = new EntityArmorParticles();
        event.registerReloadListener((PreparableReloadListener)ENTITY_ARMOR_PARTICLES);
        BLOCK_AMBIENT_PARTICLES = new BlockAmbientParticles();
        event.registerReloadListener((PreparableReloadListener)BLOCK_AMBIENT_PARTICLES);
        BLOCK_STEP_PARTICLES = new BlockStepParticles();
        event.registerReloadListener((PreparableReloadListener)BLOCK_STEP_PARTICLES);
    }

    public void registerParticleProviders(ParticleFactoryRegisterEvent event) {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        engine.m_107378_((ParticleType)VisualityParticleTypes.SPARKLE.get(), SparkleParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.BONE.get(), SolidFallingParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.WITHER_BONE.get(), SolidFallingParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.FEATHER.get(), FeatherParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.SMALL_SLIME_BLOB.get(), SlimeParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.MEDIUM_SLIME_BLOB.get(), SlimeParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.BIG_SLIME_BLOB.get(), SlimeParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.CHARGE.get(), ChargeParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.WATER_CIRCLE.get(), WaterCircleParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.EMERALD.get(), SolidFallingParticle.Provider::new);
        engine.m_107378_((ParticleType)VisualityParticleTypes.SOUL.get(), SoulParticle.Provider::new);
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(ID, path);
    }
}

