/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.goggles.GoggleConfigScreen;
import com.simibubi.create.content.logistics.trains.CameraDistanceModifier;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.SubMenuConfigScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.ui.PonderIndexScreen;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.CameraAngleAnimationService;
import com.simibubi.create.foundation.utility.Components;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public class SConfigureConfigPacket
extends SimplePacketBase {
    private final String option;
    private final String value;

    public SConfigureConfigPacket(String option, String value) {
        this.option = option;
        this.value = value;
    }

    public SConfigureConfigPacket(FriendlyByteBuf buffer) {
        this.option = buffer.m_130136_(Short.MAX_VALUE);
        this.value = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.option);
        buffer.m_130070_(this.value);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.option.startsWith("SET")) {
                SConfigureConfigPacket.trySetConfig(this.option.substring(3), this.value);
                return;
            }
            try {
                Actions.valueOf(this.option).performAction(this.value);
            }
            catch (IllegalArgumentException e) {
                LogManager.getLogger().warn("Received ConfigureConfigPacket with invalid Option: " + this.option);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    private static void trySetConfig(String option, String value) {
        ConfigHelper.ConfigPath configPath;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        try {
            configPath = ConfigHelper.ConfigPath.parse(option);
        }
        catch (IllegalArgumentException e) {
            player.m_5661_((Component)Components.literal(e.getMessage()), false);
            return;
        }
        if (configPath.getType() != ModConfig.Type.CLIENT) {
            Create.LOGGER.warn("Received type-mismatched config packet on client");
            return;
        }
        try {
            ConfigHelper.setConfigValue(configPath, value);
            player.m_5661_((Component)Components.literal("Great Success!"), false);
        }
        catch (ConfigHelper.InvalidValueException e) {
            player.m_5661_((Component)Components.literal("Config could not be set the the specified value!"), false);
        }
        catch (Exception e) {
            player.m_5661_((Component)Components.literal("Something went wrong while trying to set config value. Check the client logs for more information"), false);
            Create.LOGGER.warn("Exception during client-side config value set:", (Throwable)e);
        }
    }

    public static enum Actions {
        configScreen(() -> Actions::configScreen),
        rainbowDebug(() -> Actions::rainbowDebug),
        overlayScreen(() -> Actions::overlayScreen),
        fixLighting(() -> Actions::experimentalLighting),
        overlayReset(() -> Actions::overlayReset),
        openPonder(() -> Actions::openPonder),
        fabulousWarning(() -> Actions::fabulousWarning),
        zoomMultiplier(() -> Actions::zoomMultiplier),
        camAngleYawTarget(() -> value -> Actions.camAngleTarget(value, true)),
        camAnglePitchTarget(() -> value -> Actions.camAngleTarget(value, false)),
        camAngleFunction(() -> Actions::camAngleFunction);

        private final Supplier<Consumer<String>> consumer;

        private Actions(Supplier<Consumer<String>> action) {
            this.consumer = action;
        }

        void performAction(String value) {
            this.consumer.get().accept(value);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void configScreen(String value) {
            ConfigHelper.ConfigPath configPath;
            if (value.equals("")) {
                ScreenOpener.open(BaseConfigScreen.forCreate(null));
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            try {
                configPath = ConfigHelper.ConfigPath.parse(value);
            }
            catch (IllegalArgumentException e) {
                player.m_5661_((Component)Components.literal(e.getMessage()), false);
                return;
            }
            try {
                ScreenOpener.open(SubMenuConfigScreen.find(configPath));
            }
            catch (Exception e) {
                player.m_5661_((Component)Components.literal("Unable to find the specified config"), false);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void rainbowDebug(String value) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || "".equals(value)) {
                return;
            }
            if (value.equals("info")) {
                MutableComponent text = Components.literal("Rainbow Debug Utility is currently: ").m_7220_((Component)Actions.boolToText((Boolean)AllConfigs.CLIENT.rainbowDebug.get()));
                player.m_5661_((Component)text, false);
                return;
            }
            AllConfigs.CLIENT.rainbowDebug.set(Boolean.parseBoolean(value));
            MutableComponent text = Actions.boolToText((Boolean)AllConfigs.CLIENT.rainbowDebug.get()).m_7220_((Component)Components.literal(" Rainbow Debug Utility").m_130940_(ChatFormatting.WHITE));
            player.m_5661_((Component)text, false);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void overlayReset(String value) {
            AllConfigs.CLIENT.overlayOffsetX.set(0);
            AllConfigs.CLIENT.overlayOffsetY.set(0);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void overlayScreen(String value) {
            ScreenOpener.open(new GoggleConfigScreen());
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void experimentalLighting(String value) {
            ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.set((Object)true);
            Minecraft.m_91087_().f_91060_.m_109818_();
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void openPonder(String value) {
            if (value.equals("index")) {
                ScreenOpener.transitionTo(new PonderIndexScreen());
                return;
            }
            ResourceLocation id = new ResourceLocation(value);
            if (!PonderRegistry.ALL.containsKey(id)) {
                Create.LOGGER.error("Could not find ponder scenes for item: " + id);
                return;
            }
            ScreenOpener.transitionTo(PonderUI.of(id));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void fabulousWarning(String value) {
            AllConfigs.CLIENT.ignoreFabulousWarning.set(true);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)Components.literal("Disabled Fabulous graphics warning"), false);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void zoomMultiplier(String value) {
            try {
                float v = Float.parseFloat(value);
                if (v <= 0.0f) {
                    return;
                }
                CameraDistanceModifier.zoomOut(v);
            }
            catch (NumberFormatException ignored) {
                Create.LOGGER.debug("Received non-float value {} in zoom packet, ignoring", (Object)value);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void camAngleTarget(String value, boolean yaw) {
            try {
                float v = Float.parseFloat(value);
                if (yaw) {
                    CameraAngleAnimationService.setYawTarget(v);
                } else {
                    CameraAngleAnimationService.setPitchTarget(v);
                }
            }
            catch (NumberFormatException ignored) {
                Create.LOGGER.debug("Received non-float value {} in camAngle packet, ignoring", (Object)value);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void camAngleFunction(String value) {
            CameraAngleAnimationService.Mode mode = CameraAngleAnimationService.Mode.LINEAR;
            String modeString = value;
            float speed = -1.0f;
            String[] split = value.split(":");
            if (split.length > 1) {
                modeString = split[0];
                try {
                    speed = Float.parseFloat(split[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                mode = CameraAngleAnimationService.Mode.valueOf(modeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            CameraAngleAnimationService.setAnimationMode(mode);
            CameraAngleAnimationService.setAnimationSpeed(speed);
        }

        private static MutableComponent boolToText(boolean b) {
            return b ? Components.literal("enabled").m_130940_(ChatFormatting.DARK_GREEN) : Components.literal("disabled").m_130940_(ChatFormatting.RED);
        }
    }
}

