/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreenList;
import com.simibubi.create.foundation.config.ui.HintableTextFieldWidget;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class ConfigModListScreen
extends ConfigScreen {
    ConfigScreenList list;
    HintableTextFieldWidget search;
    BoxWidget goBack;
    List<ModEntry> allEntries;

    public ConfigModListScreen(Screen parent) {
        super(parent);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int listWidth = Math.min(this.f_96543_ - 80, 300);
        this.list = new ConfigScreenList(this.f_96541_, listWidth, this.f_96544_ - 60, 15, this.f_96544_ - 45, 40);
        this.list.m_93507_(this.f_96543_ / 2 - this.list.getWidth() / 2);
        this.m_142416_(this.list);
        this.allEntries = new ArrayList<ModEntry>();
        ModList.get().getMods().stream().map(IModInfo::getModId).forEach(id -> this.allEntries.add(new ModEntry((String)id, this)));
        this.allEntries.sort((e1, e2) -> {
            int empty = (e2.button.f_93623_ ? 1 : 0) - (e1.button.f_93623_ ? 1 : 0);
            if (empty != 0) {
                return empty;
            }
            return e1.id.compareToIgnoreCase(e2.id);
        });
        this.list.m_6702_().clear();
        this.list.m_6702_().addAll(this.allEntries);
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.f_96543_ / 2 - listWidth / 2 - 30, this.f_96544_ / 2 + 65, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> ScreenOpener.open(this.parent));
        this.goBack.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((Component)Components.literal("Go Back"));
        this.m_142416_(this.goBack);
        this.search = new HintableTextFieldWidget(this.f_96547_, this.f_96543_ / 2 - listWidth / 2, this.f_96544_ - 35, listWidth, 20);
        this.search.m_94151_(this::updateFilter);
        this.search.setHint("Search...");
        this.search.m_94198_();
        this.m_142416_((GuiEventListener)this.search);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259) {
            ScreenOpener.open(this.parent);
        }
        return false;
    }

    private void updateFilter(String search) {
        this.list.m_6702_().clear();
        this.allEntries.stream().filter(modEntry -> modEntry.id.contains(search.toLowerCase(Locale.ROOT))).forEach(this.list.m_6702_()::add);
        this.list.m_93410_(this.list.m_93517_());
        if (this.list.m_6702_().size() > 0) {
            this.search.m_94202_(Theme.i(Theme.Key.TEXT));
        } else {
            this.search.m_94202_(Theme.i(Theme.Key.BUTTON_FAIL));
        }
    }

    public static class ModEntry
    extends ConfigScreenList.LabeledEntry {
        protected BoxWidget button;
        protected String id;

        public ModEntry(String id, Screen parent) {
            super(ConfigScreen.toHumanReadable(id));
            this.id = id;
            this.button = (BoxWidget)new BoxWidget(0, 0, 35, 16).showingElement((RenderElement)AllIcons.I_CONFIG_OPEN.asStencil().at(10.0f, 0.0f));
            this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.button)));
            if (ConfigHelper.hasAnyForgeConfig(id)) {
                this.button.withCallback(() -> ScreenOpener.open(new BaseConfigScreen(parent, id)));
            } else {
                this.button.f_93623_ = false;
                this.button.updateColorsFromState();
                this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BaseConfigScreen.DISABLED_RENDERER));
                this.labelTooltip.add(Components.literal(ConfigScreen.toHumanReadable(id)));
                this.labelTooltip.addAll(TooltipHelper.cutTextComponent((Component)Components.literal("This Mod does not have any configs registered or is not using Forge's config system"), ChatFormatting.GRAY, ChatFormatting.GRAY));
            }
            this.listeners.add(this.button);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void tick() {
            super.tick();
            this.button.tick();
        }

        @Override
        public void m_6311_(PoseStack ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.m_6311_(ms, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.f_93620_ = x + width - 108;
            this.button.f_93621_ = y + 10;
            this.button.setHeight(height - 20);
            this.button.m_6305_(ms, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }
    }
}

