/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.TooltipArea;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;

public class ModularGuiLine {
    List<Pair<AbstractWidget, String>> widgets = new ArrayList<Pair<AbstractWidget, String>>();
    List<Couple<Integer>> customBoxes = new ArrayList<Couple<Integer>>();
    boolean speechBubble = false;

    public void renderWidgetBG(int guiLeft, PoseStack ms) {
        boolean first = true;
        if (!this.customBoxes.isEmpty()) {
            for (Couple<Integer> couple : this.customBoxes) {
                int x = (Integer)couple.getFirst() + guiLeft;
                int width = (Integer)couple.getSecond();
                this.box(ms, x, width, first & this.speechBubble);
                first = false;
            }
            return;
        }
        for (Pair<AbstractWidget, String> pair : this.widgets) {
            if (pair.getSecond().equals("Dummy")) continue;
            AbstractWidget aw = pair.getFirst();
            int x = aw.f_93620_;
            int width = aw.m_5711_();
            if (aw instanceof EditBox) {
                x -= 5;
                width += 9;
            }
            this.box(ms, x, width, first & this.speechBubble);
            first = false;
        }
    }

    private void box(PoseStack ms, int x, int width, boolean b) {
        UIRenderHelper.drawStretched(ms, x, 0, width, 18, 0, AllGuiTextures.DATA_AREA);
        if (b) {
            AllGuiTextures.DATA_AREA_SPEECH.render(ms, x - 3, 0);
        } else {
            AllGuiTextures.DATA_AREA_START.render(ms, x, 0);
        }
        AllGuiTextures.DATA_AREA_END.render(ms, x + width - 2, 0);
    }

    public void saveValues(CompoundTag data) {
        for (Pair<AbstractWidget, String> pair : this.widgets) {
            AbstractWidget w = pair.getFirst();
            String key = pair.getSecond();
            if (w instanceof EditBox) {
                EditBox eb = (EditBox)w;
                data.m_128359_(key, eb.m_94155_());
            }
            if (!(w instanceof ScrollInput)) continue;
            ScrollInput si = (ScrollInput)w;
            data.m_128405_(key, si.getState());
        }
    }

    public <T extends GuiEventListener & Widget> void loadValues(CompoundTag data, Consumer<T> addRenderable, Consumer<T> addRenderableOnly) {
        for (Pair<AbstractWidget, String> pair : this.widgets) {
            AbstractWidget w = pair.getFirst();
            String key = pair.getSecond();
            if (w instanceof EditBox) {
                EditBox eb = (EditBox)w;
                eb.m_94144_(data.m_128461_(key));
            }
            if (w instanceof ScrollInput) {
                ScrollInput si = (ScrollInput)w;
                si.setState(data.m_128451_(key));
            }
            if (w instanceof TooltipArea) {
                addRenderableOnly.accept(w);
                continue;
            }
            addRenderable.accept(w);
        }
    }

    public void forEach(Consumer<GuiEventListener> callback) {
        this.widgets.forEach((? super T p) -> callback.accept((GuiEventListener)p.getFirst()));
    }

    public void clear() {
        this.widgets.clear();
        this.customBoxes.clear();
    }

    public void add(Pair<AbstractWidget, String> pair) {
        this.widgets.add(pair);
    }
}

