/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueUpdatePacket;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ScrollValueBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<ScrollValueBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform slotPositioning;
    Vec3 textShift;
    int min = 0;
    int max = 1;
    public int value;
    public int scrollableValue;
    int ticksUntilScrollPacket;
    boolean forceClientState;
    Component label;
    Consumer<Integer> callback;
    Consumer<Integer> clientCallback;
    Function<Integer, String> formatter;
    Function<Integer, Component> unit;
    Function<StepContext, Integer> step;
    private Supplier<Boolean> isActive;
    boolean needsWrench;

    public ScrollValueBehaviour(Component label, SmartTileEntity te, ValueBoxTransform slot) {
        super(te);
        this.setLabel(label);
        this.slotPositioning = slot;
        this.callback = i -> {};
        this.clientCallback = i -> {};
        this.textShift = Vec3.f_82478_;
        this.formatter = i -> Integer.toString(i);
        this.step = c -> 1;
        this.value = 0;
        this.isActive = () -> true;
        this.ticksUntilScrollPacket = -1;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128405_("ScrollValue", this.value);
        if (clientPacket && this.forceClientState) {
            nbt.m_128379_("ForceScrollable", true);
            this.forceClientState = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        this.value = nbt.m_128451_("ScrollValue");
        if (nbt.m_128441_("ForceScrollable")) {
            this.ticksUntilScrollPacket = -1;
            this.scrollableValue = this.value;
        }
        super.read(nbt, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getWorld().f_46443_) {
            return;
        }
        if (this.ticksUntilScrollPacket == -1) {
            return;
        }
        if (this.ticksUntilScrollPacket > 0) {
            --this.ticksUntilScrollPacket;
            return;
        }
        AllPackets.channel.sendToServer((Object)new ScrollValueUpdatePacket(this.getPos(), this.scrollableValue));
        this.ticksUntilScrollPacket = -1;
    }

    public ScrollValueBehaviour withClientCallback(Consumer<Integer> valueCallback) {
        this.clientCallback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour withCallback(Consumer<Integer> valueCallback) {
        this.callback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour between(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollValueBehaviour moveText(Vec3 shift) {
        this.textShift = shift;
        return this;
    }

    public ScrollValueBehaviour requiresWrench() {
        this.needsWrench = true;
        return this;
    }

    public ScrollValueBehaviour withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollValueBehaviour withUnit(Function<Integer, Component> unit) {
        this.unit = unit;
        return this;
    }

    public ScrollValueBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public ScrollValueBehaviour withStepFunction(Function<StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setValue(this.value);
        this.scrollableValue = this.value;
    }

    public void setValue(int value) {
        if ((value = Mth.m_14045_((int)value, (int)this.min, (int)this.max)) == this.value) {
            return;
        }
        this.value = value;
        this.forceClientState = true;
        this.callback.accept(value);
        this.tileEntity.m_6596_();
        this.tileEntity.sendData();
        this.scrollableValue = value;
    }

    public int getValue() {
        return this.value;
    }

    public String formatValue() {
        return this.formatter.apply(this.scrollableValue);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public boolean testHit(Vec3 hit) {
        BlockState state = this.tileEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.tileEntity.m_58899_()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    public static class StepContext {
        public int currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }
}

